/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.literal.FalseLiteralExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.NullLiteralExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.NumberLiteralExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.StringLiteralExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.TrueLiteralExpression;
import org.apache.qpid.server.query.engine.parsing.factory.NumberExpressionFactory;

public final class LiteralExpressionFactory {
    private LiteralExpressionFactory() {
    }

    public static <T> FalseLiteralExpression<T> createFalse() {
        return new FalseLiteralExpression();
    }

    public static <T> TrueLiteralExpression<T> createTrue() {
        return new TrueLiteralExpression();
    }

    public static <T, R> NullLiteralExpression<T, R> createNull() {
        return new NullLiteralExpression();
    }

    public static <T> StringLiteralExpression<T> string(String source) {
        return new StringLiteralExpression(source);
    }

    public static <T> NumberLiteralExpression<T> fromDecimal(String source) {
        return new NumberLiteralExpression(NumberExpressionFactory.fromDecimal(source));
    }

    public static <T> ExpressionNode<T, Number> fromHex(String source) {
        return new NumberLiteralExpression(NumberExpressionFactory.fromHex(source));
    }

    public static <T> ExpressionNode<T, Number> fromOctal(String source) {
        return new NumberLiteralExpression(NumberExpressionFactory.fromOctal(source));
    }

    public static <T> ExpressionNode<T, Number> fromDouble(String source) {
        return new NumberLiteralExpression(NumberExpressionFactory.fromDouble(source));
    }
}

