
# PIP-399: Fix Metric Name for Delayed Queue

# Background knowledge

Pulsar delayed delivery is a feature that allows messages to be delivered to consumers after a certain delay.
It will expose a metric to monitor the memory usage of delayed queue.

# Motivation

There is already one metric called `pulsar_delayed_message_index_size_bytes` for the total memory occupation used by delayed queue of **one topic**.
```
writeMetric(stream, "pulsar_delayed_message_index_size_bytes", stats.delayedTrackerMemoryUsage,
                cluster, namespace, topic, splitTopicAndPartitionIndexLabel);
```

Whereas, the metric for **one sub** also called `pulsar_delayed_message_index_size_bytes`, which do not comform the metric name norm and is confusing.
```
writeSubscriptionMetric(stream, "pulsar_delayed_message_index_size_bytes",
                    subsStats.delayedTrackerMemoryUsage, cluster, namespace, topic, sub, splitTopicAndPartitionIndexLabel);
```

Currently, it can export metric like:
```
# TYPE pulsar_delayed_message_index_size_bytes gauge
pulsar_delayed_message_index_size_bytes{cluster="MyPulsar",namespace="public/default",topic="persistent://public/default/testNack-partition-0"} 0
pulsar_delayed_message_index_size_bytes{cluster="MyPulsar",namespace="public/default",topic="persistent://public/default/testNack-partition-0",subscription="sub2"} 0
```

The metric of topic and subscription mix together. If we want to filter out the metric of sub to pick out the metric of topic, we need to use promsql like:
`pulsar_delayed_message_index_size_bytes{subscription=""}`
It is quite weird and not friendly to use.


# Goals

Rename the metric for **one sub** to `pulsar_subscription_delayed_message_index_size_bytes`.


# Backward & Forward Compatibility

## Upgrade

Rename the metric for **one sub** to `pulsar_subscription_delayed_message_index_size_bytes`.

## Downgrade / Rollback

Rename the metric for **one sub** to `pulsar_delayed_message_index_size_bytes`.



# General Notes

# Links

<!--
Updated afterwards
-->
* Mailing List discussion thread: https://lists.apache.org/thread/b8rqld3cww1t34zntgmld50yz34lxx1d
* Mailing List voting thread: https://lists.apache.org/thread/cyyx29ggjdpbr3kq5vvd6tk83f9vc112
