/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.StatusOr;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.CdsLoadBalancerProvider;
import io.grpc.xds.ClusterResolverLoadBalancerProvider;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClusterResource;
import io.grpc.xds.XdsConfig;
import io.grpc.xds.client.XdsLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

final class CdsLoadBalancer2
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final LoadBalancerRegistry lbRegistry;
    private GracefulSwitchLoadBalancer delegate;
    private String clusterName;
    private XdsConfig.Subscription clusterSubscription;

    CdsLoadBalancer2(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.delegate = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cds-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Object gracefulConfig;
        XdsConfig xdsConfig;
        StatusOr clusterConfigOr;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.clusterName == null) {
            CdsLoadBalancerProvider.CdsConfig config = (CdsLoadBalancerProvider.CdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Config: {0}", config);
            if (config.isDynamic) {
                this.clusterSubscription = ((XdsConfig.XdsClusterSubscriptionRegistry)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLUSTER_SUBSCRIPT_REGISTRY)).subscribeToCluster(config.name);
            }
            this.clusterName = config.name;
        }
        if ((clusterConfigOr = (StatusOr)(xdsConfig = (XdsConfig)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CONFIG)).getClusters().get((Object)this.clusterName)) == null) {
            if (this.clusterSubscription == null) {
                return this.fail(Status.INTERNAL.withDescription(this.errorPrefix() + "Unable to find non-dynamic cluster"));
            }
            return Status.OK;
        }
        if (!clusterConfigOr.hasValue()) {
            return this.fail(clusterConfigOr.getStatus());
        }
        XdsConfig.XdsClusterConfig clusterConfig = (XdsConfig.XdsClusterConfig)clusterConfigOr.getValue();
        if (clusterConfig.getChildren() instanceof XdsConfig.XdsClusterConfig.EndpointConfig) {
            NameResolver.ConfigOrError configOrError = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(Arrays.asList(clusterConfig.getClusterResource().lbPolicyConfig()), (LoadBalancerRegistry)this.lbRegistry);
            if (configOrError.getError() != null) {
                return this.fail(Status.INTERNAL.withDescription(this.errorPrefix() + "Unable to parse the LB config: " + configOrError.getError()));
            }
            XdsClusterResource.CdsUpdate result = clusterConfig.getClusterResource();
            ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance = result.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.EDS ? ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.forEds(this.clusterName, result.edsServiceName(), result.lrsServerInfo(), result.maxConcurrentRequests(), result.upstreamTlsContext(), result.filterMetadata(), result.outlierDetection()) : ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.forLogicalDns(this.clusterName, result.dnsHostName(), result.lrsServerInfo(), result.maxConcurrentRequests(), result.upstreamTlsContext(), result.filterMetadata());
            gracefulConfig = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)this.lbRegistry.getProvider("cluster_resolver_experimental"), (Object)new ClusterResolverLoadBalancerProvider.ClusterResolverConfig(instance, configOrError.getConfig(), clusterConfig.getClusterResource().isHttp11ProxyAvailable()));
        } else if (clusterConfig.getChildren() instanceof XdsConfig.XdsClusterConfig.AggregateConfig) {
            HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityChildConfigs = new HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig>();
            List<String> leafClusters = ((XdsConfig.XdsClusterConfig.AggregateConfig)clusterConfig.getChildren()).getLeafNames();
            for (String childCluster : leafClusters) {
                priorityChildConfigs.put(childCluster, new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)this.lbRegistry.getProvider("cds_experimental"), (Object)new CdsLoadBalancerProvider.CdsConfig(childCluster)), false));
            }
            gracefulConfig = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)this.lbRegistry.getProvider("priority_experimental"), (Object)new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(priorityChildConfigs), leafClusters));
        } else {
            return this.fail(Status.INTERNAL.withDescription(this.errorPrefix() + "Unexpected cluster children type: " + clusterConfig.getChildren().getClass()));
        }
        return this.delegate.acceptResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(gracefulConfig).build());
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.delegate != null) {
            this.delegate.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
        }
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        this.delegate.shutdown();
        this.delegate = new GracefulSwitchLoadBalancer(this.helper);
        if (this.clusterSubscription != null) {
            this.clusterSubscription.close();
            this.clusterSubscription = null;
        }
    }

    @CheckReturnValue
    private Status fail(Status error) {
        this.delegate.shutdown();
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
        return Status.OK;
    }

    private String errorPrefix() {
        return "CdsLb for " + this.clusterName + ": ";
    }
}

