/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.util.Recycler;
import java.util.BitSet;
import org.apache.commons.lang3.tuple.Pair;

public class EntryBatchIndexesAcks {
    private int size = 100;
    private Pair<Integer, long[]>[] indexesAcks = new Pair[this.size];
    private final Recycler.Handle<EntryBatchIndexesAcks> handle;
    private static final Recycler<EntryBatchIndexesAcks> RECYCLER = new Recycler<EntryBatchIndexesAcks>(){

        protected EntryBatchIndexesAcks newObject(Recycler.Handle<EntryBatchIndexesAcks> handle) {
            return new EntryBatchIndexesAcks(handle);
        }
    };

    public void setIndexesAcks(int entryIdx, Pair<Integer, long[]> indexesAcks) {
        this.indexesAcks[entryIdx] = indexesAcks;
    }

    public long[] getAckSet(int entryIdx) {
        Pair<Integer, long[]> pair = this.indexesAcks[entryIdx];
        return pair == null ? null : (long[])pair.getRight();
    }

    public int getTotalAckedIndexCount() {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            Pair<Integer, long[]> pair = this.indexesAcks[i];
            if (pair == null) continue;
            count += (Integer)pair.getLeft() - BitSet.valueOf((long[])pair.getRight()).cardinality();
        }
        return count;
    }

    public void recycle() {
        for (int i = 0; i < this.size; ++i) {
            this.indexesAcks[i] = null;
        }
        this.handle.recycle((Object)this);
    }

    private void ensureCapacityAndSetSize(int entriesListSize) {
        this.size = entriesListSize;
        if (this.indexesAcks.length < this.size) {
            this.indexesAcks = new Pair[this.size];
        }
    }

    public static EntryBatchIndexesAcks get(int entriesListSize) {
        EntryBatchIndexesAcks ebi = (EntryBatchIndexesAcks)RECYCLER.get();
        ebi.ensureCapacityAndSetSize(entriesListSize);
        return ebi;
    }

    private EntryBatchIndexesAcks(Recycler.Handle<EntryBatchIndexesAcks> handle) {
        this.handle = handle;
    }
}

