/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitDecision;
import org.apache.pulsar.common.stats.Metrics;

public class SplitCounter {
    private long splitCount = 0L;
    private final Map<SplitDecision.Label, Map<SplitDecision.Reason, AtomicLong>> breakdownCounters = Map.of(SplitDecision.Label.Success, Map.of(SplitDecision.Reason.Topics, new AtomicLong(), SplitDecision.Reason.Sessions, new AtomicLong(), SplitDecision.Reason.MsgRate, new AtomicLong(), SplitDecision.Reason.Bandwidth, new AtomicLong(), SplitDecision.Reason.Admin, new AtomicLong()), SplitDecision.Label.Failure, Map.of(SplitDecision.Reason.Unknown, new AtomicLong()));
    private volatile long updatedAt = 0L;

    public void update(SplitDecision decision) {
        if (decision.label == SplitDecision.Label.Success) {
            ++this.splitCount;
        }
        this.breakdownCounters.get((Object)decision.getLabel()).get((Object)decision.getReason()).incrementAndGet();
        this.updatedAt = System.currentTimeMillis();
    }

    public void update(SplitDecision.Label label, SplitDecision.Reason reason) {
        if (label == SplitDecision.Label.Success) {
            ++this.splitCount;
        }
        this.breakdownCounters.get((Object)label).get((Object)reason).incrementAndGet();
        this.updatedAt = System.currentTimeMillis();
    }

    public List<Metrics> toMetrics(String advertisedBrokerAddress) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("metric", "bundlesSplit");
        dimensions.put("broker", advertisedBrokerAddress);
        Metrics m = Metrics.create(dimensions);
        m.put("brk_lb_bundles_split_total", (Object)this.splitCount);
        metrics.add(m);
        for (Map.Entry<SplitDecision.Label, Map<SplitDecision.Reason, AtomicLong>> etr : this.breakdownCounters.entrySet()) {
            SplitDecision.Label result = etr.getKey();
            for (Map.Entry<SplitDecision.Reason, AtomicLong> counter : etr.getValue().entrySet()) {
                SplitDecision.Reason reason = counter.getKey();
                AtomicLong count = counter.getValue();
                HashMap<String, String> breakdownDims = new HashMap<String, String>(dimensions);
                breakdownDims.put("result", result.toString());
                breakdownDims.put("reason", reason.toString());
                Metrics breakdownMetric = Metrics.create(breakdownDims);
                breakdownMetric.put("brk_lb_bundles_split_breakdown_total", (Object)count.get());
                metrics.add(breakdownMetric);
            }
        }
        return metrics;
    }

    public long updatedAt() {
        return this.updatedAt;
    }
}

