# PIP-190: Simplify documentation release and maintenance strategy

- Status: Accepted/Implemented
- Author: momo-jun
- Pull Request: [#16938](https://github.com/apache/pulsar/issues/16938), https://github.com/apache/pulsar-site/pull/157
- Mailing List discussion: [Discussion](https://lists.apache.org/thread/g5b8lcwtn10ox7vd67n31om9w1rxn4l7), [Vote](https://lists.apache.org/thread/0h9s79yt9kd20ogqk8q42vbd64s2k5jc)
- Release: applies to 2.8.x and later versions


## Motivation

This proposal is focused on improving and simplifying the release and maintenance strategy of the existing Apache Pulsar documentation.

In general, this proposal provides equal values and a better user experience without making overwhelming sacrifices in the release and maintenance process. The benefits include:
* Improve user experience when they look for the documentation of a specific release.
* Optimize the doc development and release process for bug-fix releases:
   * Turn doc development for bug-fix releases from post-release into just-in-time.
   * Save Release Manager’s effort in generating doc files for bug-fix releases.
* Save a great amount of the community’s effort in syncing doc improvements and fixes to historical doc versions that are in the maintenance cycle.

## Summary of the current strategy and activities

Pulsar version number is comprised of 3 components: major.minor.bug-fix. See [definition](pip-47.md#what-about-version-numbers).

The current practice of the Pulsar documentation is releasing and maintaining individual versions of documentation for each bug-fix releases, including:
1. The Release Manager needs to generate doc-related files for each bug-fix release. ----_This activity is canceled in this proposal._
2. The doc development for bug-fix releases can only be implemented after a release (due to item1). ----_This activity can be turned into just-in-time doc development in this proposal._
     1) The labeling process of bug-fix releases usually happens after a PR is merged. When a contributor submits a PR to change docs, he/she usually changes the doc in the master branch only, because he/she doesn’t know which release the change will be included.
     2) The doc development for bug-fix releases has a dependency on the release of the new doc version. It requires someone to manually catch up with the doc changes for bug-fix releases after the doc set is generated by the Release Manager. What’s worse, this action is sometimes missed.
3. The community keeps updating all the doc versions (15+) that are in the maintenance cycle. ---- _This activity can be narrowed down to 4 doc versions in this proposal._
4. Users have to go through [an endless list](https://pulsar.apache.org/versions/) when they want to look for the documentation of a specific release.

## Proposal

### 1. Maintain doc sets for the last 4 feature releases

Pulsar is evolving very fast and generally has a 3-month release cycle, that is, 4 feature releases per year (sometimes 3 feature releases), with even more bug-fix versions. There is a high cost to maintain a lot of old releases, backport bug fixes, and security patches. In general, the last 4 feature releases are actively supported while the next feature release is being developed. For example, the community provides feature releases for 2.7, 2.8, 2.9, and 2.10, while 2.11 is under development. See [PIP-47](pip-47.md#what-is-our-eol-policy) for more details.

Accordingly, this proposal includes the first attempt to establish the doc maintenance strategy aligned with code, that is, we only keep maintaining doc sets for the last 4 feature releases: 2.7.x, 2.8.x, 2.9.x, and 2.10.x, while 2.11.0 is under development.

### 2. Release one doc version for each feature release and bug-fix release behind

The proposal introduces a simplified strategy for releasing and maintaining an all-in-one doc version for each feature release and more bug-fix releases behind it, as shown below.
<img width="652" alt="image" src="https://user-images.githubusercontent.com/60642177/180153794-bc9812e4-c012-40fe-80b7-e17ac3fa48aa.png">

#### Doc version page mockup

The following diagram shows the mockup of how the information architecture for [the Pulsar doc version page](https://pulsar.apache.org/versions) can be simplified with clarity for entry.
<img width="862" alt="image" src="https://user-images.githubusercontent.com/60642177/180154432-41c26c60-cd75-4101-8eea-7e2c2fb40d2e.png">

The key change on this page is about the fewer, simplified menus and links for documentation, and this new structure is also easier to maintain and scale.

**Note:** This is a mockup to demo the BEFORE & AFTER. When it comes to implementation, we need to make a compromise to only apply the strategy to doc sets for 2.8.x and later versions by balancing the workload differences.

#### Compare outcomes

The biggest difference between the proposal and the current practice is the strategy of releasing docs for bug-fix releases, and the outcome is compared in the following diagram.
<img width="1019" alt="image" src="https://user-images.githubusercontent.com/60642177/180474601-3ab65e77-9aed-4949-8936-069416bfdea1.png">

#### Just-in-time doc development for bug-fix releases

As one of the outcomes, just-in-time doc development for bug-fix releases is feasible with the following facts taken into consideration.

**Facts**
* The latest stable doc set for the feature release is up and running, like 2.10.x. As soon as a few doc PRs are labeled for a bug-fix version (2.10.1), the related doc changes can be implemented right away on top of 2.10.x doc set. The dependency with generating a new version of the doc set no longer exists.
* Doc changes for improvements in bug-fix releases are limited (less than 10 PRs per version) based on previous releases. Take 2.10.1 for example:
<img width="706" alt="image" src="https://user-images.githubusercontent.com/60642177/180470087-81d59820-857c-4cf0-b1e9-6c0c2a456af8.png">

**Proposed solution**
Add an additional annotation like “This enhancement is only available for 2.10.1 and later versions.” for enhancements with doc requests in each bug-fix release. This needs to be added to the [Contribution Guide](https://docs.google.com/document/d/11DTnNPpvcPrebLkMAFcDEIFlD8ARD-k6F-LXoIwdD9Y/edit#).

## Implementation plan

### Apply the strategy to 2.8.x and later versions of documentation

By balancing the predictable workload introduced by the proposal and the unpredictable maintenance effort using the current strategy, we have to make a compromise that we only apply the strategy to 2.8.x and later versions.

The actions to change these versions of docs sets include:
1. Add annotation for 2.M.1~2.M.n-specific doc changes to the 2.M.x docs(M⪰8)
2. Rename versioned-docs/2.M.0 to versioned-docs/2.M.x
3. Remove versioned-docs/2.M.1~2.M.n from the Pulsar repo

### Update the doc version page

Use 2.10.x as the latest doc version and refresh the information for 2.8.x and 2.9.x.

### Update the release document

Remove the section of [Update the site for minor releases](https://github.com/apache/pulsar/wiki/Release-process#update-the-site-for-minor-releases).
Note that the minor releases mentioned in this section actually refer to bug-fix releases according to [the version number definition in PIP-47](pip-47.md#what-about-version-numbers).
<img width="798" alt="image" src="https://user-images.githubusercontent.com/60642177/180153487-585e5a76-fe12-4435-bc0e-79799d613abb.png">

The reason is Release Managers will not need to generate documentation and update the doc site for bug-fix releases. Take 2.10.1 for example, they can skip the following pull requests and much more effort in their local processing.
<img width="795" alt="image" src="https://user-images.githubusercontent.com/60642177/180153511-d777fe79-d3bd-4053-9a82-4a9ea100e405.png">

**Note:** The release notes for bug-fix releases are still required.

### Update the contribution guide

Update the [doc contribution guide](https://docs.google.com/document/d/11DTnNPpvcPrebLkMAFcDEIFlD8ARD-k6F-LXoIwdD9Y/edit#) to clarify the standard processing for the doc changes in bug-fix releases.
