/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.bookie.EntryKey;

public class EntryKeyValue
extends EntryKey {
    private final byte[] bytes;
    private int offset = 0;
    private int length = 0;

    public byte[] getBuffer() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public EntryKeyValue(long ledgerId, long entryId, byte[] bytes) {
        this(ledgerId, entryId, bytes, 0, bytes.length);
    }

    public EntryKeyValue(long ledgerId, long entryId, byte[] bytes, int offset, int length) {
        super(ledgerId, entryId);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public ByteBuf getValueAsByteBuffer() {
        return Unpooled.wrappedBuffer((byte[])this.getBuffer(), (int)this.getOffset(), (int)this.getLength());
    }

    int writeToByteBuffer(ByteBuffer dst) {
        if (dst.remaining() < this.getLength()) {
            throw new IllegalArgumentException("Buffer size " + dst.remaining() + " < " + this.getLength());
        }
        dst.put(this.getBuffer(), this.getOffset(), this.getLength());
        return this.getLength();
    }

    public String toString() {
        return this.ledgerId + ":" + this.entryId;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

