/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import lombok.Generated;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;

public class TransactionMetadataStoreAttributes {
    private final Attributes commonAttributes;
    private final Attributes txnAbortedAttributes;
    private final Attributes txnActiveAttributes;
    private final Attributes txnCommittedAttributes;
    private final Attributes txnCreatedAttributes;
    private final Attributes txnTimeoutAttributes;

    public TransactionMetadataStoreAttributes(TransactionMetadataStore store) {
        this.commonAttributes = Attributes.of((AttributeKey)OpenTelemetryAttributes.PULSAR_TRANSACTION_COORDINATOR_ID, (Object)store.getTransactionCoordinatorID().getId());
        this.txnAbortedAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.ABORTED.attributes).build();
        this.txnActiveAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.ACTIVE.attributes).build();
        this.txnCommittedAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.COMMITTED.attributes).build();
        this.txnCreatedAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.CREATED.attributes).build();
        this.txnTimeoutAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.TIMEOUT.attributes).build();
    }

    @Generated
    public Attributes getCommonAttributes() {
        return this.commonAttributes;
    }

    @Generated
    public Attributes getTxnAbortedAttributes() {
        return this.txnAbortedAttributes;
    }

    @Generated
    public Attributes getTxnActiveAttributes() {
        return this.txnActiveAttributes;
    }

    @Generated
    public Attributes getTxnCommittedAttributes() {
        return this.txnCommittedAttributes;
    }

    @Generated
    public Attributes getTxnCreatedAttributes() {
        return this.txnCreatedAttributes;
    }

    @Generated
    public Attributes getTxnTimeoutAttributes() {
        return this.txnTimeoutAttributes;
    }
}

