/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.io;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.distributedlog.io.CompressionCodec;

public class LZ4CompressionCodec
implements CompressionCodec {
    private static final LZ4CompressionCodec INSTANCE = new LZ4CompressionCodec();
    private static final LZ4Factory factory = LZ4Factory.fastestJavaInstance();
    private static final LZ4Compressor compressor = factory.fastCompressor();
    private static final LZ4FastDecompressor decompressor = factory.fastDecompressor();

    public static LZ4CompressionCodec of() {
        return INSTANCE;
    }

    @Override
    public ByteBuf compress(ByteBuf uncompressed, int headerLen) {
        Preconditions.checkNotNull((Object)uncompressed);
        Preconditions.checkArgument((uncompressed.readableBytes() > 0 ? 1 : 0) != 0);
        int uncompressedLen = uncompressed.readableBytes();
        int maxLen = compressor.maxCompressedLength(uncompressedLen);
        ByteBuffer uncompressedNio = uncompressed.nioBuffer(uncompressed.readerIndex(), uncompressedLen);
        ByteBuf compressed = PooledByteBufAllocator.DEFAULT.buffer(maxLen + headerLen, maxLen + headerLen);
        ByteBuffer compressedNio = compressed.nioBuffer(headerLen, maxLen);
        int compressedLen = compressor.compress(uncompressedNio, uncompressedNio.position(), uncompressedLen, compressedNio, compressedNio.position(), maxLen);
        compressed.writerIndex(compressedLen + headerLen);
        return compressed;
    }

    @Override
    public ByteBuf decompress(ByteBuf compressed, int decompressedSize) {
        Preconditions.checkNotNull((Object)compressed);
        Preconditions.checkArgument((compressed.readableBytes() >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((decompressedSize >= 0 ? 1 : 0) != 0);
        ByteBuf uncompressed = PooledByteBufAllocator.DEFAULT.buffer(decompressedSize, decompressedSize);
        ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, decompressedSize);
        ByteBuffer compressedNio = compressed.nioBuffer(compressed.readerIndex(), compressed.readableBytes());
        decompressor.decompress(compressedNio, compressedNio.position(), uncompressedNio, uncompressedNio.position(), uncompressedNio.remaining());
        uncompressed.writerIndex(decompressedSize);
        return uncompressed;
    }
}

