/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.context.storage;

import java.util.function.Supplier;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Context;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextLocalImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.context.storage.AccessMode;

public interface ContextLocal<T> {
    public static <T> ContextLocal<T> registerLocal(Class<T> type) {
        return new ContextLocalImpl();
    }

    default public T get(Context context) {
        return this.get(context, AccessMode.CONCURRENT);
    }

    default public T get(Context context, Supplier<? extends T> initialValueSupplier) {
        return this.get(context, AccessMode.CONCURRENT, initialValueSupplier);
    }

    default public void put(Context context, T data) {
        this.put(context, AccessMode.CONCURRENT, data);
    }

    default public void remove(Context context) {
        this.put(context, AccessMode.CONCURRENT, null);
    }

    default public T get(Context context, AccessMode accessMode) {
        return ((ContextInternal)context).getLocal(this, accessMode);
    }

    default public T get(Context context, AccessMode accessMode, Supplier<? extends T> initialValueSupplier) {
        return ((ContextInternal)context).getLocal(this, accessMode, initialValueSupplier);
    }

    default public void put(Context context, AccessMode accessMode, T value) {
        ((ContextInternal)context).putLocal(this, accessMode, value);
    }

    default public void remove(Context context, AccessMode accessMode) {
        this.put(context, accessMode, null);
    }
}

