/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import org.apache.pulsar.client.admin.Brokers;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.TopicVersion;
import org.apache.pulsar.common.policies.data.BrokerInfo;
import org.apache.pulsar.common.policies.data.NamespaceOwnershipStatus;
import org.apache.pulsar.common.util.Codec;

public class BrokersImpl
extends BaseResource
implements Brokers {
    private final WebTarget adminBrokers;

    public BrokersImpl(WebTarget web, Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.adminBrokers = web.path("admin/v2/brokers");
    }

    public List<String> getActiveBrokers() throws PulsarAdminException {
        return (List)this.sync(() -> this.getActiveBrokersAsync(null));
    }

    public CompletableFuture<List<String>> getActiveBrokersAsync() {
        return this.getActiveBrokersAsync(null);
    }

    public List<String> getActiveBrokers(String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getActiveBrokersAsync(cluster));
    }

    public CompletableFuture<List<String>> getActiveBrokersAsync(String cluster) {
        WebTarget path = cluster == null ? this.adminBrokers : this.adminBrokers.path(cluster);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public BrokerInfo getLeaderBroker() throws PulsarAdminException {
        return (BrokerInfo)this.sync(() -> this.getLeaderBrokerAsync());
    }

    public CompletableFuture<BrokerInfo> getLeaderBrokerAsync() {
        WebTarget path = this.adminBrokers.path("leaderBroker");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BrokerInfo>(){});
    }

    public Map<String, NamespaceOwnershipStatus> getOwnedNamespaces(String cluster, String brokerId) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getOwnedNamespacesAsync(cluster, brokerId));
    }

    public CompletableFuture<Map<String, NamespaceOwnershipStatus>> getOwnedNamespacesAsync(String cluster, String brokerId) {
        WebTarget path = this.adminBrokers.path(cluster).path(brokerId).path("ownedNamespaces");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, NamespaceOwnershipStatus>>(){});
    }

    public void updateDynamicConfiguration(String configName, String configValue) throws PulsarAdminException {
        this.sync(() -> this.updateDynamicConfigurationAsync(configName, configValue));
    }

    public CompletableFuture<Void> updateDynamicConfigurationAsync(String configName, String configValue) {
        String value = Codec.encode((String)configValue);
        WebTarget path = this.adminBrokers.path("configuration").path(configName).path(value);
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void deleteDynamicConfiguration(String configName) throws PulsarAdminException {
        this.sync(() -> this.deleteDynamicConfigurationAsync(configName));
    }

    public CompletableFuture<Void> deleteDynamicConfigurationAsync(String configName) {
        WebTarget path = this.adminBrokers.path("configuration").path(configName);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, String> getAllDynamicConfigurations() throws PulsarAdminException {
        return (Map)this.sync(this::getAllDynamicConfigurationsAsync);
    }

    public CompletableFuture<Map<String, String>> getAllDynamicConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("values");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, String>>(){});
    }

    public List<String> getDynamicConfigurationNames() throws PulsarAdminException {
        return (List)this.sync(this::getDynamicConfigurationNamesAsync);
    }

    public CompletableFuture<List<String>> getDynamicConfigurationNamesAsync() {
        WebTarget path = this.adminBrokers.path("configuration");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public Map<String, String> getRuntimeConfigurations() throws PulsarAdminException {
        return (Map)this.sync(this::getRuntimeConfigurationsAsync);
    }

    public CompletableFuture<Map<String, String>> getRuntimeConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("runtime");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, String>>(){});
    }

    public InternalConfigurationData getInternalConfigurationData() throws PulsarAdminException {
        return (InternalConfigurationData)this.sync(this::getInternalConfigurationDataAsync);
    }

    public CompletableFuture<InternalConfigurationData> getInternalConfigurationDataAsync() {
        WebTarget path = this.adminBrokers.path("internal-configuration");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<InternalConfigurationData>(){});
    }

    public void backlogQuotaCheck() throws PulsarAdminException {
        this.sync(this::backlogQuotaCheckAsync);
    }

    public CompletableFuture<Void> backlogQuotaCheckAsync() {
        WebTarget path = this.adminBrokers.path("backlog-quota-check");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Void>(){});
    }

    @Deprecated
    public void healthcheck() throws PulsarAdminException {
        this.healthcheck(TopicVersion.V1, Optional.empty());
    }

    @Deprecated
    public CompletableFuture<Void> healthcheckAsync() {
        return this.healthcheckAsync(TopicVersion.V1, Optional.empty());
    }

    public void healthcheck(TopicVersion topicVersion) throws PulsarAdminException {
        this.sync(() -> this.healthcheckAsync(topicVersion, Optional.empty()));
    }

    public void healthcheck(TopicVersion topicVersion, Optional<String> brokerId) throws PulsarAdminException {
        this.sync(() -> this.healthcheckAsync(topicVersion, brokerId));
    }

    public CompletableFuture<Void> healthcheckAsync(TopicVersion topicVersion, Optional<String> brokerId) {
        WebTarget path = this.adminBrokers.path("health");
        if (topicVersion != null) {
            path = path.queryParam("topicVersion", new Object[]{topicVersion});
        }
        if (brokerId.isPresent()) {
            path = path.queryParam("brokerId", new Object[]{brokerId.get()});
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            public void completed(String result) {
                if (!"ok".equalsIgnoreCase(result.trim())) {
                    future.completeExceptionally(new PulsarAdminException("Healthcheck returned unexpected result: " + result));
                } else {
                    future.complete(null);
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<Void> shutDownBrokerGracefully(int maxConcurrentUnloadPerSec, boolean forcedTerminateTopic) {
        WebTarget path = this.adminBrokers.path("shutdown").queryParam("maxConcurrentUnloadPerSec", new Object[]{maxConcurrentUnloadPerSec}).queryParam("forcedTerminateTopic", new Object[]{forcedTerminateTopic});
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public String getVersion() throws PulsarAdminException {
        return (String)this.sync(this::getVersionAsync);
    }

    public CompletableFuture<String> getVersionAsync() {
        WebTarget path = this.adminBrokers.path("version");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }
}

