/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.data;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.lookup.LookupResult;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.apache.pulsar.policies.data.loadbalancer.ServiceLookupData;

public record BrokerLookupData(String webServiceUrl, String webServiceUrlTls, String pulsarServiceUrl, String pulsarServiceUrlTls, Map<String, AdvertisedListener> advertisedListeners, Map<String, String> protocols, boolean persistentTopicsEnabled, boolean nonPersistentTopicsEnabled, String loadManagerClassName, long startTimestamp, String brokerVersion) implements ServiceLookupData
{
    public String getWebServiceUrl() {
        return this.webServiceUrl();
    }

    public String getWebServiceUrlTls() {
        return this.webServiceUrlTls();
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl();
    }

    public String getPulsarServiceUrlTls() {
        return this.pulsarServiceUrlTls();
    }

    public Map<String, String> getProtocols() {
        return this.protocols();
    }

    public Optional<String> getProtocol(String protocol) {
        return Optional.ofNullable(this.protocols().get(protocol));
    }

    public String getLoadManagerClassName() {
        return this.loadManagerClassName;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public LookupResult toLookupResult(LookupOptions options) throws PulsarServerException {
        if (options.hasAdvertisedListenerName()) {
            AdvertisedListener listener = this.advertisedListeners.get(options.getAdvertisedListenerName());
            if (listener == null) {
                throw new PulsarServerException("the broker do not have " + options.getAdvertisedListenerName() + " listener");
            }
            URI url = listener.getBrokerServiceUrl();
            URI urlTls = listener.getBrokerServiceUrlTls();
            return new LookupResult(this.webServiceUrl, this.webServiceUrlTls, url == null ? null : url.toString(), urlTls == null ? null : urlTls.toString(), LookupResult.Type.BrokerUrl, false);
        }
        return new LookupResult(this.webServiceUrl, this.webServiceUrlTls, this.pulsarServiceUrl, this.pulsarServiceUrlTls, LookupResult.Type.BrokerUrl, false);
    }

    public NamespaceEphemeralData toNamespaceEphemeralData() {
        return new NamespaceEphemeralData(this.pulsarServiceUrl, this.pulsarServiceUrlTls, this.webServiceUrl, this.webServiceUrlTls, false, this.advertisedListeners);
    }
}

