/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.common.util.Revisioned;
import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamMetadata;
import org.apache.bookkeeper.stream.proto.StreamName;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.storage.CreateNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.CreateStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.GetActiveRangesRequest;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.GetStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerEndpoint;
import org.apache.bookkeeper.stream.protocol.util.StorageContainerPlacementPolicy;
import org.apache.commons.lang3.tuple.Pair;

public class ProtoUtils {
    public static boolean keyRangeOverlaps(RangeProperties meta1, RangeProperties meta2) {
        return ProtoUtils.keyRangeOverlaps(meta1.getStartHashKey(), meta1.getEndHashKey(), meta2.getStartHashKey(), meta2.getEndHashKey());
    }

    public static boolean keyRangeOverlaps(Pair<Long, Long> range1, Pair<Long, Long> range2) {
        return ProtoUtils.keyRangeOverlaps((Long)range1.getLeft(), (Long)range1.getRight(), (Long)range2.getLeft(), (Long)range2.getRight());
    }

    public static boolean keyRangeOverlaps(RangeProperties range1, Pair<Long, Long> range2) {
        return ProtoUtils.keyRangeOverlaps(range1.getStartHashKey(), range1.getEndHashKey(), (Long)range2.getLeft(), (Long)range2.getRight());
    }

    public static boolean keyRangeOverlaps(Pair<Long, Long> range1, RangeProperties range2) {
        return ProtoUtils.keyRangeOverlaps((Long)range1.getLeft(), (Long)range1.getRight(), range2.getStartHashKey(), range2.getEndHashKey());
    }

    static boolean keyRangeOverlaps(long startKey1, long endKey1, long startKey2, long endKey2) {
        return endKey2 > startKey1 && startKey2 < endKey1;
    }

    public static boolean validateNamespaceName(String name) {
        return ProtoUtils.validateStreamName(name);
    }

    public static boolean validateStreamName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!(c == '\u0000' || c == ' ' || c == '<' || c == '>' || c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff') && (c <= '\ufff0' || c >= '\uffff')) continue;
            return false;
        }
        return true;
    }

    public static List<RangeProperties> split(long streamId, int numInitialRanges, long nextRangeId, StorageContainerPlacementPolicy placementPolicy) {
        int numRanges = Math.max(2, numInitialRanges);
        if (numRanges % 2 != 0) {
            ++numRanges;
        }
        long rangeSize = Long.MAX_VALUE / (long)(numRanges / 2);
        long startKey = Long.MIN_VALUE;
        ArrayList ranges = Lists.newArrayListWithExpectedSize((int)numRanges);
        for (int idx = 0; idx < numRanges; ++idx) {
            long rangeId;
            long endKey = startKey + rangeSize;
            if (numRanges - 1 == idx) {
                endKey = Long.MAX_VALUE;
            }
            ++nextRangeId;
            RangeProperties props = RangeProperties.newBuilder().setStartHashKey(startKey).setEndHashKey(endKey).setStorageContainerId(placementPolicy.placeStreamRange(streamId, rangeId)).setRangeId(rangeId).build();
            startKey = endKey;
            ranges.add(props);
        }
        return ranges;
    }

    public static boolean isStreamCreated(StreamMetadata.LifecycleState state) {
        Preconditions.checkArgument((state != StreamMetadata.LifecycleState.UNRECOGNIZED ? 1 : 0) != 0);
        return StreamMetadata.LifecycleState.UNINIT != state && StreamMetadata.LifecycleState.CREATING != state;
    }

    public static boolean isStreamWritable(StreamMetadata.ServingState state) {
        Preconditions.checkArgument((state != StreamMetadata.ServingState.UNRECOGNIZED ? 1 : 0) != 0);
        return StreamMetadata.ServingState.WRITABLE == state;
    }

    public static GetStorageContainerEndpointRequest createGetStorageContainerEndpointRequest(List<Revisioned<Long>> storageContainers) {
        GetStorageContainerEndpointRequest.Builder builder = GetStorageContainerEndpointRequest.newBuilder();
        for (Revisioned<Long> storageContainer : storageContainers) {
            builder.addRequests(OneStorageContainerEndpointRequest.newBuilder().setStorageContainer((Long)storageContainer.getValue()).setRevision(storageContainer.getRevision()));
        }
        return builder.build();
    }

    public static GetStorageContainerEndpointResponse createGetStorageContainerEndpointResponse(List<StorageContainerEndpoint> endpoints) {
        GetStorageContainerEndpointResponse.Builder builder = GetStorageContainerEndpointResponse.newBuilder();
        builder.setStatusCode(StatusCode.SUCCESS);
        for (StorageContainerEndpoint endpoint : endpoints) {
            builder.addResponses(OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(endpoint));
        }
        return builder.build();
    }

    public static GetActiveRangesRequest createGetActiveRangesRequest(long streamId) {
        return GetActiveRangesRequest.newBuilder().setStreamId(streamId).build();
    }

    public static GetActiveRangesRequest createGetActiveRangesRequest(StreamProperties streamProps) {
        return GetActiveRangesRequest.newBuilder().setStreamId(streamProps.getStreamId()).setStreamProps(streamProps).build();
    }

    public static CreateNamespaceRequest createCreateNamespaceRequest(String nsName, NamespaceConfiguration nsConf) {
        return CreateNamespaceRequest.newBuilder().setName(nsName).setNsConf(nsConf).build();
    }

    public static DeleteNamespaceRequest createDeleteNamespaceRequest(String colName) {
        return DeleteNamespaceRequest.newBuilder().setName(colName).build();
    }

    public static GetNamespaceRequest createGetNamespaceRequest(String colName) {
        return GetNamespaceRequest.newBuilder().setName(colName).build();
    }

    public static CreateStreamRequest createCreateStreamRequest(String nsName, String streamName, StreamConfiguration streamConf) {
        return CreateStreamRequest.newBuilder().setNsName(nsName).setName(streamName).setStreamConf(streamConf).build();
    }

    public static GetStreamRequest createGetStreamRequest(String nsName, String streamName) {
        return GetStreamRequest.newBuilder().setStreamName(StreamName.newBuilder().setNamespaceName(nsName).setStreamName(streamName)).build();
    }

    public static GetStreamRequest createGetStreamRequest(long streamId) {
        return GetStreamRequest.newBuilder().setStreamId(streamId).build();
    }

    public static DeleteStreamRequest createDeleteStreamRequest(String nsName, String streamName) {
        return DeleteStreamRequest.newBuilder().setName(streamName).setNsName(nsName).build();
    }
}

