/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import org.joda.time.chrono.ISOChronology;

@Description(value="Add the specified amount of time to the given timestamp")
@ScalarFunction(value="date_add")
public class DateAdd {
    private DateAdd() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp(p)") long timestamp) {
        long epochMillis = DateTimes.scaleEpochMicrosToMillis(timestamp);
        int microsOfMilli = DateTimes.getMicrosOfMilli(timestamp);
        epochMillis = DateTimeFunctions.getTimestampField(ISOChronology.getInstanceUTC(), unit).add(epochMillis, Math.toIntExact(value));
        if (precision <= 3L) {
            epochMillis = DateTimes.round(epochMillis, (int)(3L - precision));
        }
        return DateTimes.scaleEpochMillisToMicros(epochMillis) + (long)microsOfMilli;
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp add(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return new LongTimestamp(DateAdd.add(6L, unit, value, timestamp.getEpochMicros()), timestamp.getPicosOfMicro());
    }
}

