/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.util.Failures;
import java.util.Optional;

@ScalarFunction(value="ngrams")
@Description(value="Return N-grams for the input")
public final class ArrayNgramsFunction {
    private ArrayNgramsFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="array(array(T))")
    public static Block ngrams(@SqlType(value="array(T)") Block array, @SqlType(value="integer") long n) {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "N must be positive", new Object[0]);
        int elementsPerRecord = StrictMath.toIntExact(Math.min((long)array.getPositionCount(), n));
        int totalRecords = array.getPositionCount() - elementsPerRecord + 1;
        int[] ids = new int[totalRecords * elementsPerRecord];
        int[] offset = new int[totalRecords + 1];
        for (int recordIndex = 0; recordIndex < totalRecords; ++recordIndex) {
            for (int elementIndex = 0; elementIndex < elementsPerRecord; ++elementIndex) {
                ids[recordIndex * elementsPerRecord + elementIndex] = recordIndex + elementIndex;
            }
            offset[recordIndex + 1] = (recordIndex + 1) * elementsPerRecord;
        }
        return ArrayBlock.fromElementBlock((int)totalRecords, Optional.empty(), (int[])offset, (Block)array.getPositions(ids, 0, totalRecords * elementsPerRecord));
    }
}

