/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.KeyValuePairs;
import io.trino.operator.aggregation.MapAggregationFunction;
import io.trino.operator.aggregation.state.KeyValuePairStateSerializer;
import io.trino.operator.aggregation.state.KeyValuePairsState;
import io.trino.operator.aggregation.state.KeyValuePairsStateFactory;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MapUnionAggregation
extends SqlAggregationFunction {
    public static final String NAME = "map_union";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MapUnionAggregation.class, "output", KeyValuePairsState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MapUnionAggregation.class, "input", Type.class, BlockTypeOperators.BlockPositionEqual.class, BlockTypeOperators.BlockPositionHashCode.class, Type.class, KeyValuePairsState.class, Block.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MapUnionAggregation.class, "combine", KeyValuePairsState.class, KeyValuePairsState.class);
    private final BlockTypeOperators blockTypeOperators;

    public MapUnionAggregation(BlockTypeOperators blockTypeOperators) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Aggregate all the maps into a single map", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))));
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        MapType outputType = (MapType)boundSignature.getReturnType();
        Type keyType = outputType.getKeyType();
        BlockTypeOperators.BlockPositionEqual keyEqual = this.blockTypeOperators.getEqualOperator(keyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(keyType);
        Type valueType = outputType.getValueType();
        KeyValuePairStateSerializer stateSerializer = new KeyValuePairStateSerializer(outputType, keyEqual, keyHashCode);
        MethodHandle inputFunction = MethodHandles.insertArguments(INPUT_FUNCTION, 0, keyType, keyEqual, keyHashCode, valueType);
        inputFunction = AggregationFunctionAdapter.normalizeInputMethod(inputFunction, boundSignature, AggregationFunctionAdapter.AggregationParameterKind.STATE, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL);
        return new AggregationMetadata(inputFunction, Optional.empty(), Optional.of(COMBINE_FUNCTION), OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<KeyValuePairsState>(KeyValuePairsState.class, stateSerializer, new KeyValuePairsStateFactory(keyType, valueType))));
    }

    public static void input(Type keyType, BlockTypeOperators.BlockPositionEqual keyEqual, BlockTypeOperators.BlockPositionHashCode keyHashCode, Type valueType, KeyValuePairsState state, Block value) {
        KeyValuePairs pairs = state.get();
        if (pairs == null) {
            pairs = new KeyValuePairs(keyType, keyEqual, keyHashCode, valueType);
            state.set(pairs);
        }
        long startSize = pairs.estimatedInMemorySize();
        for (int i = 0; i < value.getPositionCount(); i += 2) {
            pairs.add(value, value, i, i + 1);
        }
        state.addMemoryUsage(pairs.estimatedInMemorySize() - startSize);
    }

    public static void combine(KeyValuePairsState state, KeyValuePairsState otherState) {
        MapAggregationFunction.combine(state, otherState);
    }

    public static void output(KeyValuePairsState state, BlockBuilder out) {
        MapAggregationFunction.output(state, out);
    }
}

