/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.CorrelationState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;

@AggregationFunction(value="corr")
public final class DoubleCorrelationAggregation {
    private DoubleCorrelationAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CorrelationState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        state.update(independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(@AggregationState CorrelationState state, @AggregationState CorrelationState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="double")
    public static void corr(@AggregationState CorrelationState state, BlockBuilder out) {
        double result = state.getCorrelation();
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }
}

