/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.PartitionFunction;
import io.trino.spi.Page;
import io.trino.spi.connector.BucketFunction;
import java.util.Objects;
import java.util.stream.IntStream;

public class BucketPartitionFunction
implements PartitionFunction {
    private final BucketFunction bucketFunction;
    private final int[] bucketToPartition;
    private final int partitionCount;

    public BucketPartitionFunction(BucketFunction bucketFunction, int[] bucketToPartition) {
        this.bucketFunction = Objects.requireNonNull(bucketFunction, "bucketFunction is null");
        this.bucketToPartition = (int[])Objects.requireNonNull(bucketToPartition, "bucketToPartition is null").clone();
        this.partitionCount = IntStream.of(bucketToPartition).max().getAsInt() + 1;
    }

    @Override
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    public int getPartition(Page functionArguments, int position) {
        int bucket = this.bucketFunction.getBucket(functionArguments, position);
        return this.bucketToPartition[bucket];
    }
}

