/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FutureStateChange<T> {
    @GuardedBy(value="listeners")
    private final Set<SettableFuture<T>> listeners = new HashSet<SettableFuture<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<T> createNewListener() {
        SettableFuture listener = SettableFuture.create();
        Set<SettableFuture<T>> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
        listener.addListener(() -> {
            Set<SettableFuture<T>> set = this.listeners;
            synchronized (set) {
                this.listeners.remove(listener);
            }
        }, MoreExecutors.directExecutor());
        return listener;
    }

    public void complete(T newState) {
        this.fireStateChange(newState, MoreExecutors.directExecutor());
    }

    public void complete(T newState, Executor executor) {
        this.fireStateChange(newState, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange(T newState, Executor executor) {
        ImmutableSet futures;
        Objects.requireNonNull(executor, "executor is null");
        Set<SettableFuture<T>> set = this.listeners;
        synchronized (set) {
            futures = ImmutableSet.copyOf(this.listeners);
            this.listeners.clear();
        }
        for (SettableFuture future : futures) {
            executor.execute(() -> future.set(newState));
        }
    }
}

