/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarDispatchingRowDecoderFactory;
import org.apache.pulsar.sql.presto.PulsarRecordCursor;
import org.apache.pulsar.sql.presto.PulsarSplit;

public class PulsarRecordSet
implements RecordSet {
    private final List<PulsarColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final PulsarSplit pulsarSplit;
    private final PulsarConnectorConfig pulsarConnectorConfig;
    private PulsarDispatchingRowDecoderFactory decoderFactory;

    public PulsarRecordSet(PulsarSplit split, List<PulsarColumnHandle> columnHandles, PulsarConnectorConfig pulsarConnectorConfig, PulsarDispatchingRowDecoderFactory decoderFactory) {
        Objects.requireNonNull(split, "split is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (PulsarColumnHandle column : columnHandles) {
            types.add((Object)column.getType());
        }
        this.columnTypes = types.build();
        this.pulsarSplit = split;
        this.pulsarConnectorConfig = pulsarConnectorConfig;
        this.decoderFactory = decoderFactory;
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new PulsarRecordCursor(this.columnHandles, this.pulsarSplit, this.pulsarConnectorConfig, this.decoderFactory);
    }
}

