/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.Page;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorPageSink;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorPageSink
implements ConnectorPageSink {
    private final ConnectorPageSink delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorPageSink(@ForClassLoaderSafe ConnectorPageSink delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public long getCompletedBytes() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getCompletedBytes();
            return l;
        }
    }

    public long getSystemMemoryUsage() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getSystemMemoryUsage();
            return l;
        }
    }

    public long getValidationCpuNanos() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getValidationCpuNanos();
            return l;
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.appendPage(page);
            return completableFuture;
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.finish();
            return completableFuture;
        }
    }

    public void abort() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.abort();
        }
    }
}

