/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonArray;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.impl.JsonUtil;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetClientOptions;

public class NetClientOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "applicationLayerProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setApplicationLayerProtocols(list);
                    break;
                }
                case "hostnameVerificationAlgorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostnameVerificationAlgorithm((String)member.getValue());
                    break;
                }
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "registerWriteHandler": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRegisterWriteHandler((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetClientOptions obj, JsonObject json) {
        NetClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(NetClientOptions obj, Map<String, Object> json) {
        if (obj.getApplicationLayerProtocols() != null) {
            JsonArray array = new JsonArray();
            obj.getApplicationLayerProtocols().forEach(item -> array.add(item));
            json.put("applicationLayerProtocols", array);
        }
        if (obj.getHostnameVerificationAlgorithm() != null) {
            json.put("hostnameVerificationAlgorithm", obj.getHostnameVerificationAlgorithm());
        }
        json.put("reconnectAttempts", obj.getReconnectAttempts());
        json.put("reconnectInterval", obj.getReconnectInterval());
        json.put("registerWriteHandler", obj.isRegisterWriteHandler());
    }
}

