/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BufferedChannel;

public class SlowBufferedChannel
extends BufferedChannel {
    public volatile long getDelay = 0L;
    public volatile long addDelay = 0L;
    public volatile long flushDelay = 0L;

    public SlowBufferedChannel(ByteBufAllocator allocator, FileChannel fc, int capacity) throws IOException {
        super(allocator, fc, capacity);
    }

    public SlowBufferedChannel(ByteBufAllocator allocator, FileChannel fc, int writeCapacity, int readCapacity) throws IOException {
        super(allocator, fc, writeCapacity, readCapacity);
    }

    public void setAddDelay(long delay) {
        this.addDelay = delay;
    }

    public void setGetDelay(long delay) {
        this.getDelay = delay;
    }

    public void setFlushDelay(long delay) {
        this.flushDelay = delay;
    }

    @Override
    public synchronized void write(ByteBuf src) throws IOException {
        SlowBufferedChannel.delayMs(this.addDelay);
        super.write(src);
    }

    @Override
    public void flush() throws IOException {
        SlowBufferedChannel.delayMs(this.flushDelay);
        super.flush();
    }

    @Override
    public long forceWrite(boolean forceMetadata) throws IOException {
        SlowBufferedChannel.delayMs(this.flushDelay);
        return super.forceWrite(forceMetadata);
    }

    @Override
    public synchronized int read(ByteBuf dest, long pos) throws IOException {
        SlowBufferedChannel.delayMs(this.getDelay);
        return super.read(dest, pos);
    }

    private static void delayMs(long delay) {
        if (delay < 1L) {
            return;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

