/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import java.util.Objects;
import java.util.Optional;

public class ClassLoaderTypeSolver
implements TypeSolver {
    private TypeSolver parent;
    private ClassLoader classLoader;

    public ClassLoaderTypeSolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        Objects.requireNonNull(parent);
        if (this.parent != null) {
            throw new IllegalStateException("This TypeSolver already has a parent.");
        }
        if (parent == this) {
            throw new IllegalStateException("The parent of this TypeSolver cannot be itself.");
        }
        this.parent = parent;
    }

    protected boolean filterName(String name) {
        return true;
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        if (this.filterName(name)) {
            try {
                if (this.classLoader == null) {
                    throw new RuntimeException("The ClassLoaderTypeSolver has been probably loaded through the bootstrap class loader. This usage is not supported by the JavaSymbolSolver");
                }
                Class<?> clazz = this.classLoader.loadClass(name);
                return SymbolReference.solved((ResolvedDeclaration)ReflectionFactory.typeDeclarationFor(clazz, this.getRoot()));
            }
            catch (NoClassDefFoundError e) {
                return SymbolReference.unsolved();
            }
            catch (ClassNotFoundException e) {
                int lastDot = name.lastIndexOf(46);
                if (lastDot == -1) {
                    return SymbolReference.unsolved();
                }
                String parentName = name.substring(0, lastDot);
                String childName = name.substring(lastDot + 1);
                SymbolReference<ResolvedReferenceTypeDeclaration> parent = this.tryToSolveType(parentName);
                if (parent.isSolved()) {
                    Optional<ResolvedReferenceTypeDeclaration> innerClass = ((ResolvedReferenceTypeDeclaration)parent.getCorrespondingDeclaration()).internalTypes().stream().filter(it -> it.getName().equals(childName)).findFirst();
                    return innerClass.map(SymbolReference::solved).orElseGet(() -> SymbolReference.unsolved());
                }
                return SymbolReference.unsolved();
            }
        }
        return SymbolReference.unsolved();
    }
}

