/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DceRpc_ObjectUuid implements Message {

  // Constant values.
  public static final Long DATA1 = 0xDEA00000L;
  public static final Integer DATA2 = 0x6C97;
  public static final Integer DATA3 = 0x11D1;
  public static final Integer DATA4 = 0x8271;

  // Properties.
  protected final byte interfaceNumber;
  protected final short nodeNumber;
  protected final int deviceId;
  protected final int vendorId;

  public DceRpc_ObjectUuid(byte interfaceNumber, short nodeNumber, int deviceId, int vendorId) {
    super();
    this.interfaceNumber = interfaceNumber;
    this.nodeNumber = nodeNumber;
    this.deviceId = deviceId;
    this.vendorId = vendorId;
  }

  public byte getInterfaceNumber() {
    return interfaceNumber;
  }

  public short getNodeNumber() {
    return nodeNumber;
  }

  public int getDeviceId() {
    return deviceId;
  }

  public int getVendorId() {
    return vendorId;
  }

  public long getData1() {
    return DATA1;
  }

  public int getData2() {
    return DATA2;
  }

  public int getData3() {
    return DATA3;
  }

  public int getData4() {
    return DATA4;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DceRpc_ObjectUuid");

    // Const Field (data1)
    writeConstField("data1", DATA1, writeUnsignedLong(writeBuffer, 32));

    // Const Field (data2)
    writeConstField("data2", DATA2, writeUnsignedInt(writeBuffer, 16));

    // Const Field (data3)
    writeConstField("data3", DATA3, writeUnsignedInt(writeBuffer, 16));

    // Const Field (data4)
    writeConstField(
        "data4",
        DATA4,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (interfaceNumber)
    writeSimpleField(
        "interfaceNumber",
        interfaceNumber,
        writeUnsignedByte(writeBuffer, 4),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (nodeNumber)
    writeSimpleField(
        "nodeNumber",
        nodeNumber,
        writeUnsignedShort(writeBuffer, 12),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (deviceId)
    writeSimpleField(
        "deviceId",
        deviceId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (vendorId)
    writeSimpleField(
        "vendorId",
        vendorId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("DceRpc_ObjectUuid");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    DceRpc_ObjectUuid _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (data1)
    lengthInBits += 32;

    // Const Field (data2)
    lengthInBits += 16;

    // Const Field (data3)
    lengthInBits += 16;

    // Const Field (data4)
    lengthInBits += 16;

    // Simple field (interfaceNumber)
    lengthInBits += 4;

    // Simple field (nodeNumber)
    lengthInBits += 12;

    // Simple field (deviceId)
    lengthInBits += 16;

    // Simple field (vendorId)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static DceRpc_ObjectUuid staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("DceRpc_ObjectUuid");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long data1 = readConstField("data1", readUnsignedLong(readBuffer, 32), DceRpc_ObjectUuid.DATA1);

    int data2 = readConstField("data2", readUnsignedInt(readBuffer, 16), DceRpc_ObjectUuid.DATA2);

    int data3 = readConstField("data3", readUnsignedInt(readBuffer, 16), DceRpc_ObjectUuid.DATA3);

    int data4 =
        readConstField(
            "data4",
            readUnsignedInt(readBuffer, 16),
            DceRpc_ObjectUuid.DATA4,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    byte interfaceNumber =
        readSimpleField(
            "interfaceNumber",
            readUnsignedByte(readBuffer, 4),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short nodeNumber =
        readSimpleField(
            "nodeNumber",
            readUnsignedShort(readBuffer, 12),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int deviceId =
        readSimpleField(
            "deviceId",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int vendorId =
        readSimpleField(
            "vendorId",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("DceRpc_ObjectUuid");
    // Create the instance
    DceRpc_ObjectUuid _dceRpc_ObjectUuid;
    _dceRpc_ObjectUuid = new DceRpc_ObjectUuid(interfaceNumber, nodeNumber, deviceId, vendorId);
    return _dceRpc_ObjectUuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DceRpc_ObjectUuid)) {
      return false;
    }
    DceRpc_ObjectUuid that = (DceRpc_ObjectUuid) o;
    return (getInterfaceNumber() == that.getInterfaceNumber())
        && (getNodeNumber() == that.getNodeNumber())
        && (getDeviceId() == that.getDeviceId())
        && (getVendorId() == that.getVendorId())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getInterfaceNumber(), getNodeNumber(), getDeviceId(), getVendorId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
