/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ModbusErrorCode {
  ILLEGAL_FUNCTION((short) 1),
  ILLEGAL_DATA_ADDRESS((short) 2),
  ILLEGAL_DATA_VALUE((short) 3),
  SLAVE_DEVICE_FAILURE((short) 4),
  ACKNOWLEDGE((short) 5),
  SLAVE_DEVICE_BUSY((short) 6),
  NEGATIVE_ACKNOWLEDGE((short) 7),
  MEMORY_PARITY_ERROR((short) 8),
  GATEWAY_PATH_UNAVAILABLE((short) 10),
  GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND((short) 11);
  private static final Map<Short, ModbusErrorCode> map;

  static {
    map = new HashMap<>();
    for (ModbusErrorCode value : ModbusErrorCode.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  ModbusErrorCode(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static ModbusErrorCode enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
