/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ViewAttributes is the corresponding interface of ViewAttributes
type ViewAttributes interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSpecifiedAttributes returns SpecifiedAttributes (property field)
	GetSpecifiedAttributes() uint32
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
	// GetWriteMask returns WriteMask (property field)
	GetWriteMask() uint32
	// GetUserWriteMask returns UserWriteMask (property field)
	GetUserWriteMask() uint32
	// GetContainsNoLoops returns ContainsNoLoops (property field)
	GetContainsNoLoops() bool
	// GetEventNotifier returns EventNotifier (property field)
	GetEventNotifier() uint8
	// IsViewAttributes is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsViewAttributes()
	// CreateBuilder creates a ViewAttributesBuilder
	CreateViewAttributesBuilder() ViewAttributesBuilder
}

// _ViewAttributes is the data-structure of this message
type _ViewAttributes struct {
	ExtensionObjectDefinitionContract
	SpecifiedAttributes uint32
	DisplayName         LocalizedText
	Description         LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	ContainsNoLoops     bool
	EventNotifier       uint8
	// Reserved Fields
	reservedField0 *uint8
}

var _ ViewAttributes = (*_ViewAttributes)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ViewAttributes)(nil)

// NewViewAttributes factory function for _ViewAttributes
func NewViewAttributes(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, containsNoLoops bool, eventNotifier uint8) *_ViewAttributes {
	if displayName == nil {
		panic("displayName of type LocalizedText for ViewAttributes must not be nil")
	}
	if description == nil {
		panic("description of type LocalizedText for ViewAttributes must not be nil")
	}
	_result := &_ViewAttributes{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SpecifiedAttributes:               specifiedAttributes,
		DisplayName:                       displayName,
		Description:                       description,
		WriteMask:                         writeMask,
		UserWriteMask:                     userWriteMask,
		ContainsNoLoops:                   containsNoLoops,
		EventNotifier:                     eventNotifier,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ViewAttributesBuilder is a builder for ViewAttributes
type ViewAttributesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, containsNoLoops bool, eventNotifier uint8) ViewAttributesBuilder
	// WithSpecifiedAttributes adds SpecifiedAttributes (property field)
	WithSpecifiedAttributes(uint32) ViewAttributesBuilder
	// WithDisplayName adds DisplayName (property field)
	WithDisplayName(LocalizedText) ViewAttributesBuilder
	// WithDisplayNameBuilder adds DisplayName (property field) which is build by the builder
	WithDisplayNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) ViewAttributesBuilder
	// WithDescription adds Description (property field)
	WithDescription(LocalizedText) ViewAttributesBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) ViewAttributesBuilder
	// WithWriteMask adds WriteMask (property field)
	WithWriteMask(uint32) ViewAttributesBuilder
	// WithUserWriteMask adds UserWriteMask (property field)
	WithUserWriteMask(uint32) ViewAttributesBuilder
	// WithContainsNoLoops adds ContainsNoLoops (property field)
	WithContainsNoLoops(bool) ViewAttributesBuilder
	// WithEventNotifier adds EventNotifier (property field)
	WithEventNotifier(uint8) ViewAttributesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ViewAttributes or returns an error if something is wrong
	Build() (ViewAttributes, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ViewAttributes
}

// NewViewAttributesBuilder() creates a ViewAttributesBuilder
func NewViewAttributesBuilder() ViewAttributesBuilder {
	return &_ViewAttributesBuilder{_ViewAttributes: new(_ViewAttributes)}
}

type _ViewAttributesBuilder struct {
	*_ViewAttributes

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ViewAttributesBuilder) = (*_ViewAttributesBuilder)(nil)

func (b *_ViewAttributesBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ViewAttributes
}

func (b *_ViewAttributesBuilder) WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, containsNoLoops bool, eventNotifier uint8) ViewAttributesBuilder {
	return b.WithSpecifiedAttributes(specifiedAttributes).WithDisplayName(displayName).WithDescription(description).WithWriteMask(writeMask).WithUserWriteMask(userWriteMask).WithContainsNoLoops(containsNoLoops).WithEventNotifier(eventNotifier)
}

func (b *_ViewAttributesBuilder) WithSpecifiedAttributes(specifiedAttributes uint32) ViewAttributesBuilder {
	b.SpecifiedAttributes = specifiedAttributes
	return b
}

func (b *_ViewAttributesBuilder) WithDisplayName(displayName LocalizedText) ViewAttributesBuilder {
	b.DisplayName = displayName
	return b
}

func (b *_ViewAttributesBuilder) WithDisplayNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) ViewAttributesBuilder {
	builder := builderSupplier(b.DisplayName.CreateLocalizedTextBuilder())
	var err error
	b.DisplayName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_ViewAttributesBuilder) WithDescription(description LocalizedText) ViewAttributesBuilder {
	b.Description = description
	return b
}

func (b *_ViewAttributesBuilder) WithDescriptionBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) ViewAttributesBuilder {
	builder := builderSupplier(b.Description.CreateLocalizedTextBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_ViewAttributesBuilder) WithWriteMask(writeMask uint32) ViewAttributesBuilder {
	b.WriteMask = writeMask
	return b
}

func (b *_ViewAttributesBuilder) WithUserWriteMask(userWriteMask uint32) ViewAttributesBuilder {
	b.UserWriteMask = userWriteMask
	return b
}

func (b *_ViewAttributesBuilder) WithContainsNoLoops(containsNoLoops bool) ViewAttributesBuilder {
	b.ContainsNoLoops = containsNoLoops
	return b
}

func (b *_ViewAttributesBuilder) WithEventNotifier(eventNotifier uint8) ViewAttributesBuilder {
	b.EventNotifier = eventNotifier
	return b
}

func (b *_ViewAttributesBuilder) Build() (ViewAttributes, error) {
	if b.DisplayName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'displayName' not set"))
	}
	if b.Description == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'description' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ViewAttributes.deepCopy(), nil
}

func (b *_ViewAttributesBuilder) MustBuild() ViewAttributes {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ViewAttributesBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ViewAttributesBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ViewAttributesBuilder) DeepCopy() any {
	_copy := b.CreateViewAttributesBuilder().(*_ViewAttributesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateViewAttributesBuilder creates a ViewAttributesBuilder
func (b *_ViewAttributes) CreateViewAttributesBuilder() ViewAttributesBuilder {
	if b == nil {
		return NewViewAttributesBuilder()
	}
	return &_ViewAttributesBuilder{_ViewAttributes: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ViewAttributes) GetExtensionId() int32 {
	return int32(375)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ViewAttributes) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ViewAttributes) GetSpecifiedAttributes() uint32 {
	return m.SpecifiedAttributes
}

func (m *_ViewAttributes) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_ViewAttributes) GetDescription() LocalizedText {
	return m.Description
}

func (m *_ViewAttributes) GetWriteMask() uint32 {
	return m.WriteMask
}

func (m *_ViewAttributes) GetUserWriteMask() uint32 {
	return m.UserWriteMask
}

func (m *_ViewAttributes) GetContainsNoLoops() bool {
	return m.ContainsNoLoops
}

func (m *_ViewAttributes) GetEventNotifier() uint8 {
	return m.EventNotifier
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastViewAttributes(structType any) ViewAttributes {
	if casted, ok := structType.(ViewAttributes); ok {
		return casted
	}
	if casted, ok := structType.(*ViewAttributes); ok {
		return *casted
	}
	return nil
}

func (m *_ViewAttributes) GetTypeName() string {
	return "ViewAttributes"
}

func (m *_ViewAttributes) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (specifiedAttributes)
	lengthInBits += 32

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	// Simple field (writeMask)
	lengthInBits += 32

	// Simple field (userWriteMask)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (containsNoLoops)
	lengthInBits += 1

	// Simple field (eventNotifier)
	lengthInBits += 8

	return lengthInBits
}

func (m *_ViewAttributes) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ViewAttributes) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__viewAttributes ViewAttributes, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ViewAttributes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ViewAttributes")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	specifiedAttributes, err := ReadSimpleField(ctx, "specifiedAttributes", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'specifiedAttributes' field"))
	}
	m.SpecifiedAttributes = specifiedAttributes

	displayName, err := ReadSimpleField[LocalizedText](ctx, "displayName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'displayName' field"))
	}
	m.DisplayName = displayName

	description, err := ReadSimpleField[LocalizedText](ctx, "description", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	writeMask, err := ReadSimpleField(ctx, "writeMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeMask' field"))
	}
	m.WriteMask = writeMask

	userWriteMask, err := ReadSimpleField(ctx, "userWriteMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userWriteMask' field"))
	}
	m.UserWriteMask = userWriteMask

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	containsNoLoops, err := ReadSimpleField(ctx, "containsNoLoops", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'containsNoLoops' field"))
	}
	m.ContainsNoLoops = containsNoLoops

	eventNotifier, err := ReadSimpleField(ctx, "eventNotifier", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventNotifier' field"))
	}
	m.EventNotifier = eventNotifier

	if closeErr := readBuffer.CloseContext("ViewAttributes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ViewAttributes")
	}

	return m, nil
}

func (m *_ViewAttributes) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ViewAttributes) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ViewAttributes"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ViewAttributes")
		}

		if err := WriteSimpleField[uint32](ctx, "specifiedAttributes", m.GetSpecifiedAttributes(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'specifiedAttributes' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "displayName", m.GetDisplayName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'displayName' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "description", m.GetDescription(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}

		if err := WriteSimpleField[uint32](ctx, "writeMask", m.GetWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeMask' field")
		}

		if err := WriteSimpleField[uint32](ctx, "userWriteMask", m.GetUserWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'userWriteMask' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "containsNoLoops", m.GetContainsNoLoops(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'containsNoLoops' field")
		}

		if err := WriteSimpleField[uint8](ctx, "eventNotifier", m.GetEventNotifier(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'eventNotifier' field")
		}

		if popErr := writeBuffer.PopContext("ViewAttributes"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ViewAttributes")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ViewAttributes) IsViewAttributes() {}

func (m *_ViewAttributes) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ViewAttributes) deepCopy() *_ViewAttributes {
	if m == nil {
		return nil
	}
	_ViewAttributesCopy := &_ViewAttributes{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SpecifiedAttributes,
		utils.DeepCopy[LocalizedText](m.DisplayName),
		utils.DeepCopy[LocalizedText](m.Description),
		m.WriteMask,
		m.UserWriteMask,
		m.ContainsNoLoops,
		m.EventNotifier,
		m.reservedField0,
	}
	_ViewAttributesCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ViewAttributesCopy
}

func (m *_ViewAttributes) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
