/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier is the corresponding interface of BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier
type BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetFaultParameterFaultExtendedParametersEntry
	// GetObjectidentifierValue returns ObjectidentifierValue (property field)
	GetObjectidentifierValue() BACnetApplicationTagObjectIdentifier
	// IsBACnetFaultParameterFaultExtendedParametersEntryObjectidentifier is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultParameterFaultExtendedParametersEntryObjectidentifier()
	// CreateBuilder creates a BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder
	CreateBACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder() BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder
}

// _BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier is the data-structure of this message
type _BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier struct {
	BACnetFaultParameterFaultExtendedParametersEntryContract
	ObjectidentifierValue BACnetApplicationTagObjectIdentifier
}

var _ BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier = (*_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier)(nil)
var _ BACnetFaultParameterFaultExtendedParametersEntryRequirements = (*_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier)(nil)

// NewBACnetFaultParameterFaultExtendedParametersEntryObjectidentifier factory function for _BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier
func NewBACnetFaultParameterFaultExtendedParametersEntryObjectidentifier(peekedTagHeader BACnetTagHeader, objectidentifierValue BACnetApplicationTagObjectIdentifier) *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier {
	if objectidentifierValue == nil {
		panic("objectidentifierValue of type BACnetApplicationTagObjectIdentifier for BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier must not be nil")
	}
	_result := &_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier{
		BACnetFaultParameterFaultExtendedParametersEntryContract: NewBACnetFaultParameterFaultExtendedParametersEntry(peekedTagHeader),
		ObjectidentifierValue: objectidentifierValue,
	}
	_result.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder is a builder for BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier
type BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder
	// WithObjectidentifierValue adds ObjectidentifierValue (property field)
	WithObjectidentifierValue(BACnetApplicationTagObjectIdentifier) BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder
	// WithObjectidentifierValueBuilder adds ObjectidentifierValue (property field) which is build by the builder
	WithObjectidentifierValueBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetFaultParameterFaultExtendedParametersEntryBuilder
	// Build builds the BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier or returns an error if something is wrong
	Build() (BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier
}

// NewBACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder() creates a BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder
func NewBACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder() BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder {
	return &_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder{_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier: new(_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier)}
}

type _BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder struct {
	*_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier

	parentBuilder *_BACnetFaultParameterFaultExtendedParametersEntryBuilder

	collectedErr []error
}

var _ (BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) = (*_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder)(nil)

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) setParent(contract BACnetFaultParameterFaultExtendedParametersEntryContract) {
	b.BACnetFaultParameterFaultExtendedParametersEntryContract = contract
	contract.(*_BACnetFaultParameterFaultExtendedParametersEntry)._SubType = b._BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) WithMandatoryFields(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder {
	return b.WithObjectidentifierValue(objectidentifierValue)
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) WithObjectidentifierValue(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder {
	b.ObjectidentifierValue = objectidentifierValue
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) WithObjectidentifierValueBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder {
	builder := builderSupplier(b.ObjectidentifierValue.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.ObjectidentifierValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) Build() (BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier, error) {
	if b.ObjectidentifierValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectidentifierValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier.deepCopy(), nil
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) MustBuild() BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) Done() BACnetFaultParameterFaultExtendedParametersEntryBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetFaultParameterFaultExtendedParametersEntryBuilder().(*_BACnetFaultParameterFaultExtendedParametersEntryBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) buildForBACnetFaultParameterFaultExtendedParametersEntry() (BACnetFaultParameterFaultExtendedParametersEntry, error) {
	return b.Build()
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder().(*_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder creates a BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder
func (b *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) CreateBACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder() BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder {
	if b == nil {
		return NewBACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder()
	}
	return &_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierBuilder{_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) GetParent() BACnetFaultParameterFaultExtendedParametersEntryContract {
	return m.BACnetFaultParameterFaultExtendedParametersEntryContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) GetObjectidentifierValue() BACnetApplicationTagObjectIdentifier {
	return m.ObjectidentifierValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultParameterFaultExtendedParametersEntryObjectidentifier(structType any) BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier {
	if casted, ok := structType.(BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) GetTypeName() string {
	return "BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier"
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry).getLengthInBits(ctx))

	// Simple field (objectidentifierValue)
	lengthInBits += m.ObjectidentifierValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetFaultParameterFaultExtendedParametersEntry) (__bACnetFaultParameterFaultExtendedParametersEntryObjectidentifier BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier, err error) {
	m.BACnetFaultParameterFaultExtendedParametersEntryContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectidentifierValue, err := ReadSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectidentifierValue", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectidentifierValue' field"))
	}
	m.ObjectidentifierValue = objectidentifierValue

	if closeErr := readBuffer.CloseContext("BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier")
	}

	return m, nil
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier")
		}

		if err := WriteSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectidentifierValue", m.GetObjectidentifierValue(), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectidentifierValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier")
		}
		return nil
	}
	return m.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) IsBACnetFaultParameterFaultExtendedParametersEntryObjectidentifier() {
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) deepCopy() *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier {
	if m == nil {
		return nil
	}
	_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierCopy := &_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier{
		m.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.ObjectidentifierValue),
	}
	_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierCopy.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry)._SubType = m
	return _BACnetFaultParameterFaultExtendedParametersEntryObjectidentifierCopy
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryObjectidentifier) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
