/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	api "github.com/apache/plc4x/plc4go/pkg/api/values"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/apache/plc4x/plc4go/spi/values"
)

// Code generated by code-generation. DO NOT EDIT.

func DataItemParse(ctx context.Context, theBytes []byte, plcValueType api.PlcValueType, stringLength int32) (api.PlcValue, error) {
	return DataItemParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), plcValueType, stringLength)
}

func DataItemParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, plcValueType api.PlcValueType, stringLength int32) (api.PlcValue, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	readBuffer.PullContext("DataItem")
	switch {
	case plcValueType == api.BOOL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcBOOL(value), nil
	case plcValueType == api.BYTE: // BYTE
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcBYTE(value), nil
	case plcValueType == api.WORD: // WORD
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcWORD(value), nil
	case plcValueType == api.DWORD: // DWORD
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcDWORD(value), nil
	case plcValueType == api.LWORD: // LWORD
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcLWORD(value), nil
	case plcValueType == api.SINT: // SINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcSINT(value), nil
	case plcValueType == api.USINT: // USINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcUSINT(value), nil
	case plcValueType == api.INT: // INT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcINT(value), nil
	case plcValueType == api.UINT: // UINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcUINT(value), nil
	case plcValueType == api.DINT: // DINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcDINT(value), nil
	case plcValueType == api.UDINT: // UDINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcUDINT(value), nil
	case plcValueType == api.LINT: // LINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcLINT(value), nil
	case plcValueType == api.ULINT: // ULINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcULINT(value), nil
	case plcValueType == api.REAL: // REAL
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcREAL(value), nil
	case plcValueType == api.LREAL: // LREAL
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcLREAL(value), nil
	case plcValueType == api.CHAR: // CHAR
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(8), utils.WithEncoding("Windows-1252"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcCHAR(value), nil
	case plcValueType == api.WCHAR: // WCHAR
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(16), utils.WithEncoding("UTF-16LE"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcWCHAR(value), nil
	case plcValueType == api.STRING: // STRING
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32((stringLength)*(8)), utils.WithEncoding("Windows-1252"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("DataItem")
		return values.NewPlcSTRING(value), nil
	case plcValueType == api.WSTRING: // WSTRING
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(((stringLength)*(8))*(2)), utils.WithEncoding("UTF-16LE"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("reserved", 16); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("DataItem")
		return values.NewPlcWSTRING(value), nil
	case plcValueType == api.TIME: // TIME
		// Simple Field (milliseconds)
		milliseconds, _millisecondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("milliseconds", 32)
		if _millisecondsErr != nil {
			return nil, errors.Wrap(_millisecondsErr, "Error parsing 'milliseconds' field")
		}
		_ = milliseconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcTIMEFromMilliseconds(int64(milliseconds)), nil
	case plcValueType == api.LTIME: // LTIME
		// Simple Field (nanoseconds)
		nanoseconds, _nanosecondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("nanoseconds", 64)
		if _nanosecondsErr != nil {
			return nil, errors.Wrap(_nanosecondsErr, "Error parsing 'nanoseconds' field")
		}
		_ = nanoseconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcLTIMEFromNanoseconds(nanoseconds), nil
	case plcValueType == api.DATE: // DATE
		// Simple Field (secondsSinceEpoch)
		secondsSinceEpoch, _secondsSinceEpochErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("secondsSinceEpoch", 32)
		if _secondsSinceEpochErr != nil {
			return nil, errors.Wrap(_secondsSinceEpochErr, "Error parsing 'secondsSinceEpoch' field")
		}
		_ = secondsSinceEpoch // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcDATEFromSecondsSinceEpoch(uint32(secondsSinceEpoch)), nil
	case plcValueType == api.LDATE: // LDATE
		// Simple Field (nanosecondsSinceEpoch)
		nanosecondsSinceEpoch, _nanosecondsSinceEpochErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("nanosecondsSinceEpoch", 64)
		if _nanosecondsSinceEpochErr != nil {
			return nil, errors.Wrap(_nanosecondsSinceEpochErr, "Error parsing 'nanosecondsSinceEpoch' field")
		}
		_ = nanosecondsSinceEpoch // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcLDATEFromNanosecondsSinceEpoch(uint64(nanosecondsSinceEpoch)), nil
	case plcValueType == api.TIME_OF_DAY: // TIME_OF_DAY
		// Simple Field (millisecondsSinceMidnight)
		millisecondsSinceMidnight, _millisecondsSinceMidnightErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("millisecondsSinceMidnight", 32)
		if _millisecondsSinceMidnightErr != nil {
			return nil, errors.Wrap(_millisecondsSinceMidnightErr, "Error parsing 'millisecondsSinceMidnight' field")
		}
		_ = millisecondsSinceMidnight // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcTIME_OF_DAYFromMillisecondsSinceMidnight(millisecondsSinceMidnight), nil
	case plcValueType == api.LTIME_OF_DAY: // LTIME_OF_DAY
		// Simple Field (nanosecondsSinceMidnight)
		nanosecondsSinceMidnight, _nanosecondsSinceMidnightErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("nanosecondsSinceMidnight", 64)
		if _nanosecondsSinceMidnightErr != nil {
			return nil, errors.Wrap(_nanosecondsSinceMidnightErr, "Error parsing 'nanosecondsSinceMidnight' field")
		}
		_ = nanosecondsSinceMidnight // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcLTIME_OF_DAYFromNanosecondsSinceMidnight(nanosecondsSinceMidnight), nil
	case plcValueType == api.DATE_AND_TIME: // DATE_AND_TIME
		// Simple Field (secondsSinceEpoch)
		secondsSinceEpoch, _secondsSinceEpochErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("secondsSinceEpoch", 32)
		if _secondsSinceEpochErr != nil {
			return nil, errors.Wrap(_secondsSinceEpochErr, "Error parsing 'secondsSinceEpoch' field")
		}
		_ = secondsSinceEpoch // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcDATA_AND_TIMEFromSecondsSinceEpoch(secondsSinceEpoch), nil
	case plcValueType == api.LDATE_AND_TIME: // LDATE_AND_TIME
		// Simple Field (nanosecondsSinceEpoch)
		nanosecondsSinceEpoch, _nanosecondsSinceEpochErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("nanosecondsSinceEpoch", 64)
		if _nanosecondsSinceEpochErr != nil {
			return nil, errors.Wrap(_nanosecondsSinceEpochErr, "Error parsing 'nanosecondsSinceEpoch' field")
		}
		_ = nanosecondsSinceEpoch // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("DataItem")
		return values.NewPlcLDATE_AND_TIMEFromNanosecondsSinceEpoch(uint64(nanosecondsSinceEpoch)), nil
	}
	// TODO: add more info which type it is actually
	return nil, errors.New("unsupported type")
}

func DataItemSerialize(value api.PlcValue, plcValueType api.PlcValueType, stringLength int32) ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := DataItemSerializeWithWriteBuffer(context.Background(), wb, value, plcValueType, stringLength); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

type _DataItem struct {
	PlcValueType api.PlcValueType
	StringLength int32
}

func (m _DataItem) GetPlcValueType() api.PlcValueType {
	return m.PlcValueType
}

func (m _DataItem) GetStringLength() int32 {
	return m.StringLength
}

func DataItemSerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer, value api.PlcValue, plcValueType api.PlcValueType, stringLength int32) error {
	log := zerolog.Ctx(ctx)
	_ = log
	m := _DataItem{
		PlcValueType: plcValueType,
		StringLength: stringLength,
	}
	_ = m
	writeBuffer.PushContext("DataItem")
	switch {
	case plcValueType == api.BOOL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.BYTE: // BYTE
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.WORD: // WORD
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.DWORD: // DWORD
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.LWORD: // LWORD
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("value", 64, uint64(value.GetUint64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.SINT: // SINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt8("value", 8, int8(value.GetInt8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.USINT: // USINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.INT: // INT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.UINT: // UINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.DINT: // DINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.UDINT: // UDINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.LINT: // LINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt64("value", 64, int64(value.GetInt64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.ULINT: // ULINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("value", 64, uint64(value.GetUint64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.REAL: // REAL
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.LREAL: // LREAL
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat64("value", 64, value.GetFloat64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.CHAR: // CHAR
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(8), value.GetString(), utils.WithEncoding("Windows-1252)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.WCHAR: // WCHAR
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(16), value.GetString(), utils.WithEncoding("UTF-16LE)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case plcValueType == api.STRING: // STRING
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32((stringLength)*(8)), value.GetString(), utils.WithEncoding("Windows-1252)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case plcValueType == api.WSTRING: // WSTRING
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(((stringLength)*(8))*(2)), value.GetString(), utils.WithEncoding("UTF-16LE)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("reserved", 16, uint16(uint16(0x0000))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case plcValueType == api.TIME: // TIME
		// Simple Field (milliseconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("milliseconds", 32, uint32(value.(values.PlcTIME).GetMilliseconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'milliseconds' field")
		}
	case plcValueType == api.LTIME: // LTIME
		// Simple Field (nanoseconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("nanoseconds", 64, uint64(value.(values.PlcLTIME).GetNanoseconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanoseconds' field")
		}
	case plcValueType == api.DATE: // DATE
		// Simple Field (secondsSinceEpoch)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("secondsSinceEpoch", 32, uint32(value.(values.PlcDATE).GetSecondsSinceEpoch())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'secondsSinceEpoch' field")
		}
	case plcValueType == api.LDATE: // LDATE
		// Simple Field (nanosecondsSinceEpoch)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("nanosecondsSinceEpoch", 64, uint64(value.(values.PlcLDATE).GetNanosecondsSinceEpoch())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanosecondsSinceEpoch' field")
		}
	case plcValueType == api.TIME_OF_DAY: // TIME_OF_DAY
		// Simple Field (millisecondsSinceMidnight)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("millisecondsSinceMidnight", 32, uint32(value.(values.PlcTIME_OF_DAY).GetMillisecondsSinceMidnight())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'millisecondsSinceMidnight' field")
		}
	case plcValueType == api.LTIME_OF_DAY: // LTIME_OF_DAY
		// Simple Field (nanosecondsSinceMidnight)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("nanosecondsSinceMidnight", 64, uint64(value.(values.PlcLTIME_OF_DAY).GetNanosecondsSinceMidnight())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanosecondsSinceMidnight' field")
		}
	case plcValueType == api.DATE_AND_TIME: // DATE_AND_TIME
		// Simple Field (secondsSinceEpoch)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("secondsSinceEpoch", 32, uint32(value.(values.PlcDATE_AND_TIME).GetSecondsSinceEpoch())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'secondsSinceEpoch' field")
		}
	case plcValueType == api.LDATE_AND_TIME: // LDATE_AND_TIME
		// Simple Field (nanosecondsSinceEpoch)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("nanosecondsSinceEpoch", 64, uint64(value.(values.PlcLDATE_AND_TIME).GetNanosecondsSinceEpoch())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanosecondsSinceEpoch' field")
		}
	default:
		// TODO: add more info which type it is actually
		return errors.New("unsupported type")
	}
	writeBuffer.PopContext("DataItem")
	return nil
}
