/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.managed.ManagedReadOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSlice;
import org.apache.hadoop.ozone.om.snapshot.PersistentMap;
import org.apache.hadoop.util.ClosableIterator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDbPersistentMap<K, V>
implements PersistentMap<K, V> {
    private final ManagedRocksDB db;
    private final ColumnFamilyHandle columnFamilyHandle;
    private final CodecRegistry codecRegistry;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public RocksDbPersistentMap(@Nonnull ManagedRocksDB db, @Nonnull ColumnFamilyHandle columnFamilyHandle, @Nonnull CodecRegistry codecRegistry, @Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        this.db = db;
        this.columnFamilyHandle = columnFamilyHandle;
        this.codecRegistry = codecRegistry;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public V get(K key) {
        try {
            byte[] rawKey = this.codecRegistry.asRawData(key);
            byte[] rawValue = ((RocksDB)this.db.get()).get(this.columnFamilyHandle, rawKey);
            return (V)this.codecRegistry.asObject(rawValue, this.valueType);
        }
        catch (IOException | RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            byte[] rawKey = this.codecRegistry.asRawData(key);
            byte[] rawValue = this.codecRegistry.asRawData(value);
            ((RocksDB)this.db.get()).put(this.columnFamilyHandle, rawKey, rawValue);
        }
        catch (IOException | RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void remove(K key) {
        try {
            byte[] rawKey = this.codecRegistry.asRawData(key);
            ((RocksDB)this.db.get()).delete(this.columnFamilyHandle, rawKey);
        }
        catch (IOException | RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public ClosableIterator<Map.Entry<K, V>> iterator(Optional<K> lowerBound, Optional<K> upperBound) {
        ManagedSlice upperBoundSlice;
        ManagedSlice lowerBoundSlice;
        final ManagedReadOptions readOptions = new ManagedReadOptions();
        try {
            if (lowerBound.isPresent()) {
                lowerBoundSlice = new ManagedSlice(this.codecRegistry.asRawData(lowerBound.get()));
                readOptions.setIterateLowerBound((AbstractSlice)lowerBoundSlice);
            } else {
                lowerBoundSlice = null;
            }
            if (upperBound.isPresent()) {
                upperBoundSlice = new ManagedSlice(this.codecRegistry.asRawData(upperBound.get()));
                readOptions.setIterateUpperBound((AbstractSlice)upperBoundSlice);
            } else {
                upperBoundSlice = null;
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        final ManagedRocksIterator iterator = ManagedRocksIterator.managed((RocksIterator)((RocksDB)this.db.get()).newIterator(this.columnFamilyHandle, (ReadOptions)readOptions));
        ((RocksIterator)iterator.get()).seekToFirst();
        return new ClosableIterator<Map.Entry<K, V>>(){

            public boolean hasNext() {
                return ((RocksIterator)iterator.get()).isValid();
            }

            public Map.Entry<K, V> next() {
                Object value;
                Object key;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements in the map.");
                }
                try {
                    key = RocksDbPersistentMap.this.codecRegistry.asObject(((RocksIterator)iterator.get()).key(), RocksDbPersistentMap.this.keyType);
                    value = RocksDbPersistentMap.this.codecRegistry.asObject(((RocksIterator)iterator.get()).value(), RocksDbPersistentMap.this.valueType);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                ((RocksIterator)iterator.get()).next();
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return value;
                    }

                    @Override
                    public V setValue(V value2) {
                        throw new IllegalStateException("setValue is not implemented.");
                    }
                };
            }

            public void close() {
                iterator.close();
                readOptions.close();
                if (upperBoundSlice != null) {
                    upperBoundSlice.close();
                }
                if (lowerBoundSlice != null) {
                    lowerBoundSlice.close();
                }
            }
        };
    }
}

