/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class SnapshotDirectoryCleaningService
extends AbstractKeyDeletingService {
    private static final int SNAPSHOT_DIR_CORE_POOL_SIZE = 1;
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private final Map<String, Long> exclusiveSizeMap = new HashMap<String, Long>();
    private final Map<String, Long> exclusiveReplicatedSizeMap = new HashMap<String, Long>();

    public SnapshotDirectoryCleaningService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient) {
        super(SnapshotDirectoryCleaningService.class.getSimpleName(), interval, unit, 1, serviceTimeout, ozoneManager, scmClient);
    }

    private boolean shouldRun() {
        if (this.getOzoneManager() == null) {
            return true;
        }
        return this.getOzoneManager().isLeaderReady() && !this.suspended.get();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new SnapshotDirTask());
        return queue;
    }

    private void iterateDirectoryTree(Table.KeyValue<String, OmKeyInfo> deletedDirInfo, long volumeId, OmBucketInfo bucketInfo, SnapshotInfo previousSnapshot, SnapshotInfo previousToPrevSnapshot, OmSnapshot currOmSnapshot, Table<String, OmKeyInfo> previousKeyTable, Table<String, String> prevRenamedTable, Table<String, OmKeyInfo> previousToPrevKeyTable, String dbBucketKeyForDir) throws IOException {
        Table snapDirTable = currOmSnapshot.getMetadataManager().getDirectoryTable();
        Table snapRenamedTable = currOmSnapshot.getMetadataManager().getSnapshotRenamedTable();
        Stack<StackNode> stackNodes = new Stack<StackNode>();
        OmDirectoryInfo omDeletedDirectoryInfo = OMFileRequest.getDirectoryInfo((OmKeyInfo)deletedDirInfo.getValue());
        String dirPathDbKey = currOmSnapshot.getMetadataManager().getOzonePathKey(volumeId, bucketInfo.getObjectID(), omDeletedDirectoryInfo);
        StackNode topLevelDir = new StackNode();
        topLevelDir.setDirKey(dirPathDbKey);
        topLevelDir.setDirValue(omDeletedDirectoryInfo);
        stackNodes.push(topLevelDir);
        Throwable throwable = null;
        Object var19_19 = null;
        try (TableIterator directoryIterator = snapDirTable.iterator((Object)dbBucketKeyForDir);){
            while (!stackNodes.isEmpty()) {
                StackNode stackTop = (StackNode)stackNodes.peek();
                if (StringUtils.isEmpty((CharSequence)stackTop.getSubDirSeek())) {
                    this.processFilesUnderDir(previousSnapshot, previousToPrevSnapshot, volumeId, bucketInfo, stackTop.getDirValue(), currOmSnapshot.getMetadataManager(), (Table<String, String>)snapRenamedTable, previousKeyTable, prevRenamedTable, previousToPrevKeyTable);
                    String seekDirInDB = currOmSnapshot.getMetadataManager().getOzonePathKey(volumeId, bucketInfo.getObjectID(), stackTop.getDirValue().getObjectID(), "");
                    stackTop.setSubDirSeek(seekDirInDB);
                    continue;
                }
                directoryIterator.seek((Object)(String.valueOf(stackTop.getSubDirSeek()) + "\u0000"));
                if (directoryIterator.hasNext()) {
                    String prefixCheck;
                    Table.KeyValue deletedSubDirInfo = (Table.KeyValue)directoryIterator.next();
                    String deletedSubDirKey = (String)deletedSubDirInfo.getKey();
                    if (!deletedSubDirKey.startsWith(prefixCheck = currOmSnapshot.getMetadataManager().getOzoneDeletePathDirKey(stackTop.getSubDirSeek()))) {
                        stackNodes.pop();
                        continue;
                    }
                    stackTop.setSubDirSeek(deletedSubDirKey);
                    StackNode nextSubDir = new StackNode();
                    nextSubDir.setDirKey((String)deletedSubDirInfo.getKey());
                    nextSubDir.setDirValue((OmDirectoryInfo)deletedSubDirInfo.getValue());
                    stackNodes.push(nextSubDir);
                    continue;
                }
                stackNodes.pop();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateExclusiveSize(String prevSnapshotKeyTable) {
        ClientId clientId = ClientId.randomId();
        OzoneManagerProtocolProtos.SnapshotSize snapshotSize = OzoneManagerProtocolProtos.SnapshotSize.newBuilder().setExclusiveSize(this.exclusiveSizeMap.getOrDefault(prevSnapshotKeyTable, 0L).longValue()).setExclusiveReplicatedSize(this.exclusiveReplicatedSizeMap.getOrDefault(prevSnapshotKeyTable, 0L).longValue()).build();
        this.exclusiveSizeMap.remove(prevSnapshotKeyTable);
        this.exclusiveReplicatedSizeMap.remove(prevSnapshotKeyTable);
        OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest = OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(prevSnapshotKeyTable).setSnapshotSize(snapshotSize).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetSnapshotProperty).setSetSnapshotPropertyRequest(setSnapshotPropertyRequest).setClientId(clientId.toString()).build();
        this.submitRequest(omRequest, clientId);
    }

    private void processFilesUnderDir(SnapshotInfo previousSnapshot, SnapshotInfo previousToPrevSnapshot, long volumeId, OmBucketInfo bucketInfo, OmDirectoryInfo parentInfo, OMMetadataManager metadataManager, Table<String, String> snapRenamedTable, Table<String, OmKeyInfo> previousKeyTable, Table<String, String> prevRenamedTable, Table<String, OmKeyInfo> previousToPrevKeyTable) throws IOException {
        String seekFileInDB = metadataManager.getOzonePathKey(volumeId, bucketInfo.getObjectID(), parentInfo.getObjectID(), "");
        ArrayList<BlockGroup> blocksForKeyDelete = new ArrayList<BlockGroup>();
        Table fileTable = metadataManager.getFileTable();
        Throwable throwable = null;
        Object var16_16 = null;
        try (TableIterator iterator = fileTable.iterator((Object)seekFileInDB);){
            while (iterator.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                OmKeyInfo fileInfo = (OmKeyInfo)entry.getValue();
                if (!OMFileRequest.isImmediateChild(fileInfo.getParentObjectID(), parentInfo.getObjectID())) {
                    break;
                }
                String ozoneDeletePathKey = metadataManager.getOzoneDeletePathKey(fileInfo.getObjectID(), (String)entry.getKey());
                if (this.isKeyReclaimable(previousKeyTable, snapRenamedTable, fileInfo, bucketInfo, volumeId, null)) {
                    for (OmKeyLocationInfoGroup keyLocations : fileInfo.getKeyLocationVersions()) {
                        List item = keyLocations.getLocationList().stream().map(b -> new BlockID(b.getContainerID(), b.getLocalID())).collect(Collectors.toList());
                        BlockGroup keyBlocks = BlockGroup.newBuilder().setKeyName(ozoneDeletePathKey).addAllBlockIDs(item).build();
                        blocksForKeyDelete.add(keyBlocks);
                    }
                    this.getScmClient().deleteKeyBlocks(blocksForKeyDelete);
                    continue;
                }
                if (previousSnapshot == null) continue;
                this.calculateExclusiveSize(previousSnapshot, previousToPrevSnapshot, fileInfo, bucketInfo, volumeId, snapRenamedTable, previousKeyTable, prevRenamedTable, previousToPrevKeyTable, this.exclusiveSizeMap, this.exclusiveReplicatedSizeMap);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateDeepCleanSnapshotDir(String snapshotKeyTable) {
        ClientId clientId = ClientId.randomId();
        OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest = OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(snapshotKeyTable).setDeepCleanedDeletedDir(true).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetSnapshotProperty).setSetSnapshotPropertyRequest(setSnapshotPropertyRequest).setClientId(clientId.toString()).build();
        this.submitRequest(omRequest, clientId);
    }

    public void submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest, ClientId clientId) {
        try {
            if (this.isRatisEnabled()) {
                OzoneManagerRatisServer server = this.getOzoneManager().getOmRatisServer();
                RaftClientRequest raftClientRequest = RaftClientRequest.newBuilder().setClientId(clientId).setServerId(server.getRaftPeerId()).setGroupId(server.getRaftGroupId()).setCallId(this.getRunCount().get()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
                server.submitRequest(omRequest, raftClientRequest);
            } else {
                this.getOzoneManager().getOmServerProtocol().submitRequest(null, omRequest);
            }
        }
        catch (ServiceException e) {
            BackgroundService.LOG.error("Snapshot deep cleaning request failed. Will retry at next run.", (Throwable)e);
        }
    }

    private class SnapshotDirTask
    implements BackgroundTask {
        private SnapshotDirTask() {
        }

        public BackgroundTaskResult call() {
            if (!SnapshotDirectoryCleaningService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            BackgroundService.LOG.debug("Running SnapshotDirectoryCleaningService");
            SnapshotDirectoryCleaningService.this.getRunCount().incrementAndGet();
            OmSnapshotManager omSnapshotManager = SnapshotDirectoryCleaningService.this.getOzoneManager().getOmSnapshotManager();
            Table snapshotInfoTable = SnapshotDirectoryCleaningService.this.getOzoneManager().getMetadataManager().getSnapshotInfoTable();
            OmMetadataManagerImpl metadataManager = (OmMetadataManagerImpl)SnapshotDirectoryCleaningService.this.getOzoneManager().getMetadataManager();
            SnapshotChainManager snapChainManager = metadataManager.getSnapshotChainManager();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (TableIterator iterator = snapshotInfoTable.iterator();){
                    while (iterator.hasNext()) {
                        SnapshotInfo currSnapInfo = (SnapshotInfo)((Table.KeyValue)iterator.next()).getValue();
                        if (currSnapInfo.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE || currSnapInfo.getDeepCleanedDeletedDir()) continue;
                        ReferenceCounted<OmSnapshot> rcPrevOmSnapshot = null;
                        ReferenceCounted<OmSnapshot> rcPrevToPrevOmSnapshot = null;
                        try {
                            long volumeId = metadataManager.getVolumeId(currSnapInfo.getVolumeName());
                            String dbBucketKey = metadataManager.getBucketKey(currSnapInfo.getVolumeName(), currSnapInfo.getBucketName());
                            OmBucketInfo bucketInfo = (OmBucketInfo)metadataManager.getBucketTable().get((Object)dbBucketKey);
                            if (bucketInfo == null) {
                                throw new IllegalStateException("Bucket /" + currSnapInfo.getVolumeName() + "/" + currSnapInfo.getBucketName() + " is not found. BucketInfo should not be " + "null for snapshotted bucket. The OM is in " + "unexpected state.");
                            }
                            SnapshotInfo previousSnapshot = SnapshotDirectoryCleaningService.this.getPreviousActiveSnapshot(currSnapInfo, snapChainManager);
                            SnapshotInfo previousToPrevSnapshot = null;
                            Table previousKeyTable = null;
                            Table prevRenamedTable = null;
                            if (previousSnapshot != null) {
                                rcPrevOmSnapshot = omSnapshotManager.getActiveSnapshot(previousSnapshot.getVolumeName(), previousSnapshot.getBucketName(), previousSnapshot.getName());
                                OmSnapshot omPreviousSnapshot = rcPrevOmSnapshot.get();
                                previousKeyTable = omPreviousSnapshot.getMetadataManager().getKeyTable(bucketInfo.getBucketLayout());
                                prevRenamedTable = omPreviousSnapshot.getMetadataManager().getSnapshotRenamedTable();
                                previousToPrevSnapshot = SnapshotDirectoryCleaningService.this.getPreviousActiveSnapshot(previousSnapshot, snapChainManager);
                            }
                            Table previousToPrevKeyTable = null;
                            if (previousToPrevSnapshot != null) {
                                rcPrevToPrevOmSnapshot = omSnapshotManager.getActiveSnapshot(previousToPrevSnapshot.getVolumeName(), previousToPrevSnapshot.getBucketName(), previousToPrevSnapshot.getName());
                                OmSnapshot omPreviousToPrevSnapshot = rcPrevToPrevOmSnapshot.get();
                                previousToPrevKeyTable = omPreviousToPrevSnapshot.getMetadataManager().getKeyTable(bucketInfo.getBucketLayout());
                            }
                            String dbBucketKeyForDir = SnapshotUtils.getOzonePathKeyForFso(metadataManager, currSnapInfo.getVolumeName(), currSnapInfo.getBucketName());
                            Throwable throwable2 = null;
                            Object var22_25 = null;
                            try (ReferenceCounted<OmSnapshot> rcCurrOmSnapshot = omSnapshotManager.getActiveSnapshot(currSnapInfo.getVolumeName(), currSnapInfo.getBucketName(), currSnapInfo.getName());){
                                OmSnapshot currOmSnapshot = rcCurrOmSnapshot.get();
                                Table snapDeletedDirTable = currOmSnapshot.getMetadataManager().getDeletedDirTable();
                                Throwable throwable3 = null;
                                Object var27_32 = null;
                                try (TableIterator deletedDirIterator = snapDeletedDirTable.iterator((Object)dbBucketKeyForDir);){
                                    while (deletedDirIterator.hasNext()) {
                                        Table.KeyValue deletedDirInfo = (Table.KeyValue)deletedDirIterator.next();
                                        SnapshotDirectoryCleaningService.this.iterateDirectoryTree((Table.KeyValue<String, OmKeyInfo>)deletedDirInfo, volumeId, bucketInfo, previousSnapshot, previousToPrevSnapshot, currOmSnapshot, (Table<String, OmKeyInfo>)previousKeyTable, (Table<String, String>)prevRenamedTable, (Table<String, OmKeyInfo>)previousToPrevKeyTable, dbBucketKeyForDir);
                                    }
                                    SnapshotDirectoryCleaningService.this.updateDeepCleanSnapshotDir(currSnapInfo.getTableKey());
                                    if (previousSnapshot != null) {
                                        SnapshotDirectoryCleaningService.this.updateExclusiveSize(previousSnapshot.getTableKey());
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable2 == null) {
                                    throwable2 = throwable5;
                                } else if (throwable2 != throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable6) {
                            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{rcPrevOmSnapshot, rcPrevToPrevOmSnapshot});
                            throw throwable6;
                        }
                        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{rcPrevOmSnapshot, rcPrevToPrevOmSnapshot});
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                    } else if (throwable != throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                BackgroundService.LOG.error("Error while running directory deep clean on snapshots. Will retry at next run.", (Throwable)ex);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }

    private static class StackNode {
        private String dirKey;
        private OmDirectoryInfo dirValue;
        private String subDirSeek;

        private StackNode() {
        }

        public String getDirKey() {
            return this.dirKey;
        }

        public void setDirKey(String dirKey) {
            this.dirKey = dirKey;
        }

        public OmDirectoryInfo getDirValue() {
            return this.dirValue;
        }

        public void setDirValue(OmDirectoryInfo dirValue) {
            this.dirValue = dirValue;
        }

        public String getSubDirSeek() {
            return this.subDirSeek;
        }

        public void setSubDirSeek(String subDirSeek) {
            this.subDirSeek = subDirSeek;
        }

        public String toString() {
            return "StackNode{dirKey='" + this.dirKey + '\'' + ", dirObjectId=" + this.dirValue.getObjectID() + ", subDirSeek='" + this.subDirSeek + '\'' + '}';
        }
    }
}

