/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotMoveDeletedKeysResponse;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"deletedTable"})
public class OMKeyPurgeResponse
extends OmKeyResponse {
    private List<String> purgeKeyList;
    private SnapshotInfo fromSnapshot;
    private List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> keysToUpdateList;

    public OMKeyPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<String> keyList, SnapshotInfo fromSnapshot, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> keysToUpdate) {
        super(omResponse);
        this.purgeKeyList = keyList;
        this.fromSnapshot = fromSnapshot;
        this.keysToUpdateList = keysToUpdate;
    }

    public OMKeyPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        block19: {
            if (this.fromSnapshot != null) {
                OmSnapshotManager omSnapshotManager = ((OmMetadataManagerImpl)omMetadataManager).getOzoneManager().getOmSnapshotManager();
                Throwable throwable = null;
                Object var5_6 = null;
                try (ReferenceCounted<OmSnapshot> rcOmFromSnapshot = omSnapshotManager.getSnapshot(this.fromSnapshot.getSnapshotId());){
                    OmSnapshot fromOmSnapshot = rcOmFromSnapshot.get();
                    DBStore fromSnapshotStore = fromOmSnapshot.getMetadataManager().getStore();
                    Throwable throwable2 = null;
                    Object var10_13 = null;
                    try (BatchOperation writeBatch = fromSnapshotStore.initBatchOperation();){
                        this.processKeys(writeBatch, fromOmSnapshot.getMetadataManager());
                        this.processKeysToUpdate(writeBatch, fromOmSnapshot.getMetadataManager());
                        fromSnapshotStore.commitBatchOperation(writeBatch);
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            this.processKeys(batchOperation, omMetadataManager);
            this.processKeysToUpdate(batchOperation, omMetadataManager);
        }
    }

    private void processKeysToUpdate(BatchOperation batchOp, OMMetadataManager metadataManager) throws IOException {
        if (this.keysToUpdateList == null) {
            return;
        }
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos keyToUpdate : this.keysToUpdateList) {
            List keyInfosList = keyToUpdate.getKeyInfosList();
            RepeatedOmKeyInfo repeatedOmKeyInfo = OMSnapshotMoveDeletedKeysResponse.createRepeatedOmKeyInfo(keyInfosList);
            metadataManager.getDeletedTable().putWithBatch(batchOp, (Object)keyToUpdate.getKey(), (Object)repeatedOmKeyInfo);
        }
    }

    private void processKeys(BatchOperation batchOp, OMMetadataManager metadataManager) throws IOException {
        for (String key : this.purgeKeyList) {
            metadataManager.getDeletedTable().deleteWithBatch(batchOp, (Object)key);
        }
    }
}

