/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"deletedTable", "deletedDirectoryTable", "directoryTable", "fileTable"})
public class OMDirectoriesPurgeResponseWithFSO
extends OmKeyResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OMDirectoriesPurgeResponseWithFSO.class);
    private List<OzoneManagerProtocolProtos.PurgePathRequest> paths;
    private boolean isRatisEnabled;
    private Map<Pair<String, String>, OmBucketInfo> volBucketInfoMap;
    private SnapshotInfo fromSnapshotInfo;

    public OMDirectoriesPurgeResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<OzoneManagerProtocolProtos.PurgePathRequest> paths, boolean isRatisEnabled, @Nonnull BucketLayout bucketLayout, Map<Pair<String, String>, OmBucketInfo> volBucketInfoMap, SnapshotInfo fromSnapshotInfo) {
        super(omResponse, bucketLayout);
        this.paths = paths;
        this.isRatisEnabled = isRatisEnabled;
        this.volBucketInfoMap = volBucketInfoMap;
        this.fromSnapshotInfo = fromSnapshotInfo;
    }

    @Override
    public void addToDBBatch(OMMetadataManager metadataManager, BatchOperation batchOp) throws IOException {
        block20: {
            if (this.fromSnapshotInfo != null) {
                OmSnapshotManager omSnapshotManager = ((OmMetadataManagerImpl)metadataManager).getOzoneManager().getOmSnapshotManager();
                Object object = null;
                Object var5_6 = null;
                try (ReferenceCounted<OmSnapshot> rcFromSnapshotInfo = omSnapshotManager.getSnapshot(this.fromSnapshotInfo.getSnapshotId());){
                    OmSnapshot fromSnapshot = rcFromSnapshotInfo.get();
                    DBStore fromSnapshotStore = fromSnapshot.getMetadataManager().getStore();
                    Throwable throwable = null;
                    Object var10_13 = null;
                    try (BatchOperation writeBatch = fromSnapshotStore.initBatchOperation();){
                        this.processPaths(fromSnapshot.getMetadataManager(), writeBatch);
                        fromSnapshotStore.commitBatchOperation(writeBatch);
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            this.processPaths(metadataManager, batchOp);
        }
        for (OmBucketInfo omBucketInfo : this.volBucketInfoMap.values()) {
            metadataManager.getBucketTable().putWithBatch(batchOp, (Object)metadataManager.getBucketKey(omBucketInfo.getVolumeName(), omBucketInfo.getBucketName()), (Object)omBucketInfo);
        }
    }

    public void processPaths(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        for (OzoneManagerProtocolProtos.PurgePathRequest path : this.paths) {
            String ozoneDbKey;
            OmKeyInfo keyInfo;
            long volumeId = path.getVolumeId();
            long bucketId = path.getBucketId();
            List deletedSubFilesList = path.getDeletedSubFilesList();
            List markDeletedSubDirsList = path.getMarkDeletedSubDirsList();
            for (OzoneManagerProtocolProtos.KeyInfo key : markDeletedSubDirsList) {
                keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)key);
                ozoneDbKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, keyInfo.getParentObjectID(), keyInfo.getFileName());
                String ozoneDeleteKey = omMetadataManager.getOzoneDeletePathKey(key.getObjectID(), ozoneDbKey);
                omMetadataManager.getDeletedDirTable().putWithBatch(batchOperation, (Object)ozoneDeleteKey, (Object)keyInfo);
                omMetadataManager.getDirectoryTable().deleteWithBatch(batchOperation, (Object)ozoneDbKey);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("markDeletedDirList KeyName: {}, DBKey: {}", (Object)keyInfo.getKeyName(), (Object)ozoneDbKey);
            }
            for (OzoneManagerProtocolProtos.KeyInfo key : deletedSubFilesList) {
                keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)key);
                ozoneDbKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, keyInfo.getParentObjectID(), keyInfo.getFileName());
                omMetadataManager.getKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)ozoneDbKey);
                if (LOG.isDebugEnabled()) {
                    LOG.info("Move keyName:{} to DeletedTable DBKey: {}", (Object)keyInfo.getKeyName(), (Object)ozoneDbKey);
                }
                RepeatedOmKeyInfo repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)keyInfo, (long)keyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
                String deletedKey = omMetadataManager.getOzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName());
                deletedKey = omMetadataManager.getOzoneDeletePathKey(keyInfo.getObjectID(), deletedKey);
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deletedKey, (Object)repeatedOmKeyInfo);
            }
            if (!path.hasDeletedDir()) continue;
            omMetadataManager.getDeletedDirTable().deleteWithBatch(batchOperation, (Object)path.getDeletedDir());
            if (!LOG.isDebugEnabled()) continue;
            LOG.info("Purge Deleted Directory DBKey: {}", (Object)path.getDeletedDir());
        }
    }
}

