/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"deletedTable"})
public abstract class AbstractOMKeyDeleteResponse
extends OmKeyResponse {
    private boolean isRatisEnabled;

    public AbstractOMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, boolean isRatisEnabled) {
        super(omResponse);
        this.isRatisEnabled = isRatisEnabled;
    }

    public AbstractOMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, boolean isRatisEnabled, BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.isRatisEnabled = isRatisEnabled;
    }

    public AbstractOMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    protected void addDeletionToBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation, Table<String, ?> fromTable, String keyName, OmKeyInfo omKeyInfo) throws IOException {
        fromTable.deleteWithBatch(batchOperation, (Object)keyName);
        if (!this.isKeyEmpty(omKeyInfo)) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)omKeyInfo, (long)omKeyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
            String delKeyName = omMetadataManager.getOzoneDeletePathKey(omKeyInfo.getObjectID(), keyName);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)delKeyName, (Object)repeatedOmKeyInfo);
        }
    }

    protected void addDeletionToBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation, Table<String, ?> fromTable, String keyName, String deleteKeyName, OmKeyInfo omKeyInfo) throws IOException {
        fromTable.deleteWithBatch(batchOperation, (Object)keyName);
        if (!this.isKeyEmpty(omKeyInfo)) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)omKeyInfo, (long)omKeyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deleteKeyName, (Object)repeatedOmKeyInfo);
        }
    }

    @Override
    public abstract void addToDBBatch(OMMetadataManager var1, BatchOperation var2) throws IOException;

    private boolean isKeyEmpty(@Nullable OmKeyInfo keyInfo) {
        if (keyInfo == null) {
            return true;
        }
        for (OmKeyLocationInfoGroup keyLocationList : keyInfo.getKeyLocationVersions()) {
            if (keyLocationList.getLocationListCount() == 0L) continue;
            return false;
        }
        return true;
    }
}

