/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.file;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"fileTable", "openFileTable"})
public class OMRecoverLeaseResponse
extends OmKeyResponse {
    private OmKeyInfo keyInfo;
    private String dbFileKey;
    private String openKeyName;

    public OMRecoverLeaseResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, BucketLayout bucketLayout, OmKeyInfo keyInfo, String dbFileKey, String openKeyName) {
        super(omResponse, bucketLayout);
        this.keyInfo = keyInfo;
        this.dbFileKey = dbFileKey;
        this.openKeyName = openKeyName;
    }

    public OMRecoverLeaseResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.openKeyName != null) {
            omMetadataManager.getOpenKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)this.openKeyName);
            omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)this.dbFileKey, (Object)this.keyInfo);
        }
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

