/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;

public final class OMMultipartUploadUtils {
    private OMMultipartUploadUtils() {
    }

    public static String getMultipartUploadId() {
        return UUID.randomUUID() + "-" + UniqueId.next();
    }

    public static String getUploadIdFromDbKey(String key) {
        String[] split = key.split("/");
        if (split.length < 5) {
            return null;
        }
        String uploadId = split[split.length - 1];
        if (StringUtils.isEmpty((CharSequence)uploadId) || uploadId.split("-").length != 6) {
            return null;
        }
        return uploadId;
    }

    public static String getMultipartOpenKey(String volumeName, String bucketName, String keyName, String multipartUploadId, OMMetadataManager omMetadataManager, BucketLayout bucketLayout) throws IOException {
        if (bucketLayout == BucketLayout.FILE_SYSTEM_OPTIMIZED) {
            return OMMultipartUploadUtils.getMultipartOpenKeyFSO(volumeName, bucketName, keyName, multipartUploadId, omMetadataManager);
        }
        return OMMultipartUploadUtils.getMultipartOpenKey(volumeName, bucketName, keyName, multipartUploadId, omMetadataManager);
    }

    public static String getMultipartOpenKey(String volumeName, String bucketName, String keyName, String multipartUploadId, OMMetadataManager omMetadataManager) {
        return omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, multipartUploadId);
    }

    public static String getMultipartOpenKeyFSO(String volumeName, String bucketName, String keyName, String uploadID, OMMetadataManager metaMgr) throws IOException {
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
        long volumeId = metaMgr.getVolumeId(volumeName);
        long bucketId = metaMgr.getBucketId(volumeName, bucketName);
        long parentID = OMFileRequest.getParentID(volumeId, bucketId, pathComponents, keyName, metaMgr);
        String multipartKey = metaMgr.getMultipartKey(volumeId, bucketId, parentID, fileName, uploadID);
        return multipartKey;
    }

    public static boolean isMultipartKeySet(OmKeyInfo openKeyInfo) {
        return openKeyInfo.getLatestVersionLocations() != null && openKeyInfo.getLatestVersionLocations().isMultipartKey();
    }
}

