/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.upgrade;

import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerDoubleBuffer;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.upgrade.OMPrepareResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.statemachine.StateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMPrepareRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMPrepareRequest.class);

    public OMPrepareRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMPrepareResponse response;
        block5: {
            LOG.info("OM {} Received prepare request with log index {}", (Object)ozoneManager.getOMNodeId(), (Object)transactionLogIndex);
            OzoneManagerProtocolProtos.OMRequest omRequest = this.getOmRequest();
            OzoneManagerProtocolProtos.PrepareRequestArgs args = omRequest.getPrepareRequest().getArgs();
            OzoneManagerProtocolProtos.OMResponse.Builder responseBuilder = OmResponseUtil.getOMResponseBuilder(omRequest);
            responseBuilder.setCmdType(OzoneManagerProtocolProtos.Type.Prepare);
            response = null;
            Duration flushTimeout = Duration.of(args.getTxnApplyWaitTimeoutSeconds(), ChronoUnit.SECONDS);
            Duration flushCheckInterval = Duration.of(args.getTxnApplyCheckIntervalSeconds(), ChronoUnit.SECONDS);
            try {
                OzoneManagerProtocolProtos.PrepareResponse omResponse = OzoneManagerProtocolProtos.PrepareResponse.newBuilder().setTxnID(transactionLogIndex).build();
                responseBuilder.setPrepareResponse(omResponse);
                response = new OMPrepareResponse(responseBuilder.build(), transactionLogIndex);
                OzoneManagerDoubleBuffer doubleBuffer = ozoneManager.getOmRatisServer().getOmStateMachine().getOzoneManagerDoubleBuffer();
                doubleBuffer.add(response, transactionLogIndex);
                OzoneManagerRatisServer omRatisServer = ozoneManager.getOmRatisServer();
                RaftServer.Division division = omRatisServer.getServer().getDivision(omRatisServer.getRaftGroup().getGroupId());
                OMPrepareRequest.waitForLogIndex(transactionLogIndex, ozoneManager, division, flushTimeout, flushCheckInterval);
                OMPrepareRequest.takeSnapshotAndPurgeLogs(transactionLogIndex, division);
                ozoneManager.getPrepareState().finishPrepare(transactionLogIndex);
                LOG.info("OM {} prepared at log index {}. Returning response {} with log index {}", new Object[]{ozoneManager.getOMNodeId(), transactionLogIndex, omResponse, omResponse.getTxnID()});
            }
            catch (OMException e) {
                LOG.error("Prepare Request Apply failed in {}. ", (Object)ozoneManager.getOMNodeId(), (Object)e);
                response = new OMPrepareResponse(this.createErrorOMResponse(responseBuilder, (Exception)((Object)e)));
            }
            catch (IOException | InterruptedException e) {
                LOG.error("Prepare Request Apply failed in {}. ", (Object)ozoneManager.getOMNodeId(), (Object)e);
                response = new OMPrepareResponse(this.createErrorOMResponse(responseBuilder, (Exception)((Object)new OMException((Throwable)e, OMException.ResultCodes.PREPARE_FAILED))));
                try {
                    ozoneManager.getPrepareState().cancelPrepare();
                }
                catch (IOException ex) {
                    LOG.error("Failed to delete prepare marker file.", (Throwable)ex);
                }
                if (!(e instanceof InterruptedException)) break block5;
                Thread.currentThread().interrupt();
            }
        }
        return response;
    }

    private static void waitForLogIndex(long minOMDBFlushIndex, OzoneManager om, RaftServer.Division division, Duration flushTimeout, Duration flushCheckInterval) throws InterruptedException, IOException {
        long endTime = System.currentTimeMillis() + flushTimeout.toMillis();
        boolean omDBFlushed = false;
        boolean ratisStateMachineApplied = false;
        long minRatisStateMachineIndex = minOMDBFlushIndex + 1L;
        long lastRatisCommitIndex = -1L;
        long lastOMDBFlushIndex = -1L;
        LOG.info("{} waiting for index {} to flush to OM DB and index {} to flush to Ratis state machine.", new Object[]{om.getOMNodeId(), minOMDBFlushIndex, minRatisStateMachineIndex});
        while (!(omDBFlushed && ratisStateMachineApplied || System.currentTimeMillis() >= endTime)) {
            lastOMDBFlushIndex = om.getRatisSnapshotIndex();
            omDBFlushed = lastOMDBFlushIndex >= minOMDBFlushIndex;
            LOG.debug("{} Current DB transaction index {}.", (Object)om.getOMNodeId(), (Object)lastOMDBFlushIndex);
            lastRatisCommitIndex = division.getStateMachine().getLastAppliedTermIndex().getIndex();
            ratisStateMachineApplied = lastRatisCommitIndex >= minRatisStateMachineIndex;
            LOG.debug("{} Current Ratis state machine transaction index {}.", (Object)om.getOMNodeId(), (Object)lastRatisCommitIndex);
            if (omDBFlushed && ratisStateMachineApplied) continue;
            Thread.sleep(flushCheckInterval.toMillis());
        }
        if (!omDBFlushed) {
            throw new IOException(String.format("After waiting for %d seconds, OM database flushed index %d which is less than the minimum required index %d.", flushTimeout.getSeconds(), lastOMDBFlushIndex, minOMDBFlushIndex));
        }
        if (!ratisStateMachineApplied) {
            throw new IOException(String.format("After waiting for %d seconds, Ratis state machine applied index %d which is less than the minimum required index %d.", flushTimeout.getSeconds(), lastRatisCommitIndex, minRatisStateMachineIndex));
        }
    }

    public static void takeSnapshotAndPurgeLogs(long prepareIndex, RaftServer.Division division) throws IOException {
        StateMachine stateMachine = division.getStateMachine();
        long snapshotIndex = stateMachine.takeSnapshot();
        if (snapshotIndex < prepareIndex) {
            throw new IOException(String.format("OM DB snapshot index %d is less than prepare index %d. Some required logs may not havebeen persisted to the state machine.", snapshotIndex, prepareIndex));
        }
        CompletableFuture purgeFuture = division.getRaftLog().onSnapshotInstalled(snapshotIndex);
        try {
            long actualPurgeIndex = (Long)purgeFuture.get();
            if (actualPurgeIndex != snapshotIndex) {
                LOG.warn("Actual purge index {} does not match specified purge index {}. ", (Object)actualPurgeIndex, (Object)snapshotIndex);
            }
            if (actualPurgeIndex < prepareIndex) {
                throw new IOException(String.format("Actual purge index %d is less than prepare index %d. Some required logs may not have been removed.", actualPurgeIndex, prepareIndex));
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Unable to purge logs: " + e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Unable to purge logs: " + e.getMessage());
        }
    }
}

