/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.security;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.s3.security.S3SecretRequestHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.security.OMSetSecretResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSetSecretRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMSetSecretRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMSetSecretRequest.class);
    }

    public OMSetSecretRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.SetS3SecretRequest request = this.getOmRequest().getSetS3SecretRequest();
        String accessId = request.getAccessId();
        OmDBAccessIdInfo accessIdInfo = (OmDBAccessIdInfo)omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
        if (accessIdInfo == null && !ozoneManager.getS3SecretManager().hasS3Secret(accessId)) {
            throw new OMException("accessId '" + accessId + "' not found.", OMException.ResultCodes.ACCESS_ID_NOT_FOUND);
        }
        String secretKey = request.getSecretKey();
        if (StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new OMException("Secret key should not be empty", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (secretKey.length() < 8) {
            throw new OMException("Secret key length should be at least 8 characters", OMException.ResultCodes.INVALID_REQUEST);
        }
        UserGroupInformation ugi = S3SecretRequestHelper.getOrCreateUgi(accessId);
        S3SecretRequestHelper.checkAccessIdSecretOpPermission(ozoneManager, ugi, accessId);
        return this.getOmRequest();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMClientResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        IOException exception = null;
        OzoneManagerProtocolProtos.SetS3SecretRequest request = this.getOmRequest().getSetS3SecretRequest();
        String accessId = request.getAccessId();
        String secretKey = request.getSecretKey();
        try {
            omClientResponse = (OMClientResponse)ozoneManager.getS3SecretManager().doUnderLock(accessId, s3SecretManager -> {
                if (!s3SecretManager.hasS3Secret(accessId)) {
                    throw new OMException("accessId '" + accessId + "' not found.", OMException.ResultCodes.ACCESS_ID_NOT_FOUND);
                }
                S3SecretValue newS3SecretValue = S3SecretValue.of((String)accessId, (String)secretKey, (long)transactionLogIndex);
                s3SecretManager.updateCache(accessId, newS3SecretValue);
                OzoneManagerProtocolProtos.SetS3SecretResponse.Builder setSecretResponse = OzoneManagerProtocolProtos.SetS3SecretResponse.newBuilder().setAccessId(accessId).setSecretKey(secretKey);
                return new OMSetSecretResponse(accessId, newS3SecretValue, s3SecretManager, omResponse.setSetS3SecretResponse(setSecretResponse).build());
            });
        }
        catch (IOException ex) {
            exception = ex;
            omClientResponse = new OMSetSecretResponse(this.createErrorOMResponse(omResponse, ex));
        }
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("S3SetSecretUser", accessId);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.SET_S3_SECRET, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.debug("Success: SetSecret for accessKey '{}'", (Object)accessId);
        } else {
            LOG.error("Failed to SetSecret for accessKey '{}'", (Object)accessId, (Object)exception);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMSetSecretRequest.java", OMSetSecretRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.security.OMSetSecretRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 58);
    }
}

