/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCompleteResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadCompleteRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private BiFunction<OzoneManagerProtocolProtos.Part, OzoneManagerProtocolProtos.PartKeyInfo, MultipartCommitRequestPart> eTagBasedValidator = (part, partKeyInfo) -> {
        String eTag = part.getETag();
        AtomicReference dbPartETag = new AtomicReference();
        String dbPartName = null;
        if (partKeyInfo != null) {
            partKeyInfo.getPartKeyInfo().getMetadataList().stream().filter(keyValue -> keyValue.getKey().equals("ETag")).findFirst().ifPresent(kv -> dbPartETag.set(kv.getValue()));
            dbPartName = partKeyInfo.getPartName();
        }
        return new MultipartCommitRequestPart(eTag, partKeyInfo == null ? null : (String)dbPartETag.get(), StringUtils.equals((CharSequence)eTag, (CharSequence)((CharSequence)dbPartETag.get())) || StringUtils.equals((CharSequence)eTag, (CharSequence)dbPartName));
    };
    private BiFunction<OzoneManagerProtocolProtos.Part, OzoneManagerProtocolProtos.PartKeyInfo, MultipartCommitRequestPart> partNameBasedValidator = (part, partKeyInfo) -> {
        String partName = part.getPartName();
        String dbPartName = null;
        if (partKeyInfo != null) {
            dbPartName = partKeyInfo.getPartName();
        }
        return new MultipartCommitRequestPart(partName, partKeyInfo == null ? null : dbPartName, StringUtils.equals((CharSequence)partName, (CharSequence)dbPartName));
    };
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3MultipartUploadCompleteRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3MultipartUploadCompleteRequest.class);
    }

    public S3MultipartUploadCompleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest multipartUploadCompleteRequest = this.getOmRequest().getCompleteMultiPartUploadRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadCompleteRequest.getKeyArgs();
        String keyPath = keyArgs.getKeyName();
        keyPath = S3MultipartUploadCompleteRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        return this.getOmRequest().toBuilder().setCompleteMultiPartUploadRequest(multipartUploadCompleteRequest.toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(keyPath))).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        List partsList;
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest multipartUploadCompleteRequest;
        block22: {
            boolean acquiredLock;
            OMMetadataManager omMetadataManager;
            block21: {
                multipartUploadCompleteRequest = this.getOmRequest().getCompleteMultiPartUploadRequest();
                OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadCompleteRequest.getKeyArgs();
                partsList = multipartUploadCompleteRequest.getPartsListList();
                auditMap = this.buildKeyArgsAuditMap(keyArgs);
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                String requestedVolume = volumeName;
                String requestedBucket = bucketName;
                keyName = keyArgs.getKeyName();
                String uploadID = keyArgs.getMultipartUploadID();
                String multipartKey = null;
                ozoneManager.getMetrics().incNumCompleteMultipartUploads();
                omMetadataManager = ozoneManager.getMetadataManager();
                acquiredLock = false;
                OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
                omClientResponse = null;
                exception = null;
                result = null;
                try {
                    try {
                        keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                        volumeName = keyArgs.getVolumeName();
                        bucketName = keyArgs.getBucketName();
                        multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                        this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
                        this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                        acquiredLock = this.getOmLockDetails().isLockAcquired();
                        this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                        OmBucketInfo omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                        OMFileRequest.OMPathInfoWithFSO pathInfoFSO = OMFileRequest.verifyDirectoryKeysInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                        List<OmDirectoryInfo> missingParentInfos = OMDirectoryCreateRequestWithFSO.getAllMissingParentDirInfo(ozoneManager, keyArgs, omBucketInfo, pathInfoFSO, trxnLogIndex);
                        if (missingParentInfos != null) {
                            long volumeId = omMetadataManager.getVolumeId(volumeName);
                            long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                            this.addMissingParentsToCache(omBucketInfo, missingParentInfos, omMetadataManager, volumeId, bucketId, trxnLogIndex);
                            String multipartOpenKey = omMetadataManager.getMultipartKey(volumeId, bucketId, pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName(), keyArgs.getMultipartUploadID());
                            if (this.getOmKeyInfoFromOpenKeyTable(multipartOpenKey, keyName, omMetadataManager) == null) {
                                ReplicationConfig replicationConfig = OzoneConfigUtil.resolveReplicationConfigPreference(keyArgs.getType(), keyArgs.getFactor(), keyArgs.getEcReplicationConfig(), omBucketInfo != null ? omBucketInfo.getDefaultReplicationConfig() : null, ozoneManager);
                                OmKeyInfo keyInfoFromArgs = new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setReplicationConfig(replicationConfig).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList(), true))).setAcls(this.getAclsForKey(keyArgs, omBucketInfo, pathInfoFSO, ozoneManager.getPrefixManager())).setObjectID(pathInfoFSO.getLeafNodeObjectId()).setUpdateID(trxnLogIndex).setFileEncryptionInfo(keyArgs.hasFileEncryptionInfo() ? OMPBHelper.convert((OzoneManagerProtocolProtos.FileEncryptionInfoProto)keyArgs.getFileEncryptionInfo()) : null).setParentObjectID(pathInfoFSO.getLastKnownParentId()).build();
                                this.addMultiPartToCache(omMetadataManager, multipartOpenKey, pathInfoFSO, keyInfoFromArgs, trxnLogIndex);
                            }
                        }
                        String dbMultipartOpenKey = this.getDBMultipartOpenKey(volumeName, bucketName, keyName, uploadID, omMetadataManager);
                        OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
                        String ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                        String dbOzoneKey = this.getDBOzoneKey(omMetadataManager, volumeName, bucketName, keyName);
                        this.checkDirectoryAlreadyExists(ozoneManager, omBucketInfo, keyName, omMetadataManager);
                        if (multipartKeyInfo == null) {
                            throw new OMException(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName), OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                        }
                        if (partsList.size() > 0) {
                            OmMultipartKeyInfo.PartKeyInfoMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
                            if (partKeyInfoMap.size() == 0) {
                                LOG.error("Complete MultipartUpload failed for key {} , MPU Key has no parts in OM, parts given to upload are {}", (Object)ozoneKey, (Object)partsList);
                                throw new OMException(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName), OMException.ResultCodes.INVALID_PART);
                            }
                            ArrayList<Integer> partNumbers = new ArrayList<Integer>();
                            int partsListSize = this.getPartsListSize(requestedVolume, requestedBucket, keyName, ozoneKey, partNumbers, partsList);
                            ArrayList<OmKeyLocationInfo> partLocationInfos = new ArrayList<OmKeyLocationInfo>();
                            long dataSize = this.getMultipartDataSize(requestedVolume, requestedBucket, keyName, ozoneKey, partKeyInfoMap, partsListSize, partLocationInfos, partsList, ozoneManager);
                            OmKeyInfo omKeyInfo = this.getOmKeyInfo(ozoneManager, trxnLogIndex, keyArgs, volumeName, bucketName, keyName, dbMultipartOpenKey, omMetadataManager, dbOzoneKey, partKeyInfoMap, partLocationInfos, dataSize);
                            long usedBytesDiff = 0L;
                            ArrayList<OmKeyInfo> allKeyInfoToRemove = new ArrayList<OmKeyInfo>();
                            for (OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo : partKeyInfoMap) {
                                if (partNumbers.contains(partKeyInfo.getPartNumber())) continue;
                                OmKeyInfo delPartKeyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                                allKeyInfoToRemove.add(delPartKeyInfo);
                                usedBytesDiff -= delPartKeyInfo.getReplicatedSize();
                            }
                            OmKeyInfo keyToDelete = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbOzoneKey);
                            boolean isNamespaceUpdate = false;
                            if (keyToDelete != null && !omBucketInfo.getIsVersionEnabled()) {
                                RepeatedOmKeyInfo oldKeyVersionsToDelete = this.getOldVersionsToCleanUp(keyToDelete, trxnLogIndex, ozoneManager.isRatisEnabled());
                                allKeyInfoToRemove.addAll(oldKeyVersionsToDelete.getOmKeyInfoList());
                                usedBytesDiff -= keyToDelete.getReplicatedSize();
                            } else {
                                this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                                omBucketInfo.incrUsedNamespace(1L);
                                isNamespaceUpdate = true;
                            }
                            String dbBucketKey = omMetadataManager.getBucketKey(omBucketInfo.getVolumeName(), omBucketInfo.getBucketName());
                            if (usedBytesDiff != 0L) {
                                omBucketInfo.incrUsedBytes(usedBytesDiff);
                            } else if (!isNamespaceUpdate) {
                                omBucketInfo = null;
                            }
                            this.updateCache(omMetadataManager, dbBucketKey, omBucketInfo, dbOzoneKey, dbMultipartOpenKey, multipartKey, omKeyInfo, trxnLogIndex);
                            omResponse.setCompleteMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadCompleteResponse.newBuilder().setVolume(requestedVolume).setBucket(requestedBucket).setKey(keyName).setHash((String)omKeyInfo.getMetadata().get("ETag")));
                            long volumeId = omMetadataManager.getVolumeId(volumeName);
                            long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                            omClientResponse = this.getOmClientResponse(multipartKey, omResponse, dbMultipartOpenKey, omKeyInfo, allKeyInfoToRemove, omBucketInfo, volumeId, bucketId, missingParentInfos, multipartKeyInfo);
                            result = OMClientRequest.Result.SUCCESS;
                            break block21;
                        }
                        throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + " because of empty part list", OMException.ResultCodes.INVALID_REQUEST);
                    }
                    catch (IOException | InvalidPathException ex) {
                        result = OMClientRequest.Result.FAILURE;
                        exception = ex;
                        omClientResponse = this.getOmClientResponse(omResponse, exception);
                        if (acquiredLock) {
                            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                        }
                        if (omClientResponse != null) {
                            omClientResponse.setOmLockDetails(this.getOmLockDetails());
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    throw throwable;
                }
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.logResult(ozoneManager, multipartUploadCompleteRequest, partsList, auditMap, volumeName, bucketName, keyName, exception, result);
        return omClientResponse;
    }

    protected S3MultipartUploadCompleteResponse getOmClientResponse(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, Exception exception) {
        return new S3MultipartUploadCompleteResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
    }

    protected OMClientResponse getOmClientResponse(String multipartKey, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, String dbMultipartOpenKey, OmKeyInfo omKeyInfo, List<OmKeyInfo> allKeyInfoToRemove, OmBucketInfo omBucketInfo, long volumeId, long bucketId, List<OmDirectoryInfo> missingParentInfos, OmMultipartKeyInfo multipartKeyInfo) {
        return new S3MultipartUploadCompleteResponse(omResponse.build(), multipartKey, dbMultipartOpenKey, omKeyInfo, allKeyInfoToRemove, this.getBucketLayout(), omBucketInfo);
    }

    protected void checkDirectoryAlreadyExists(OzoneManager ozoneManager, OmBucketInfo omBucketInfo, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("BucketName: {}, BucketLayout: {}", (Object)omBucketInfo.getBucketName(), (Object)omBucketInfo.getBucketLayout());
        }
        if (omBucketInfo.getBucketLayout().shouldNormalizePaths(ozoneManager.getEnableFileSystemPaths()) && this.checkDirectoryAlreadyExists(omBucketInfo.getVolumeName(), omBucketInfo.getBucketName(), keyName, omMetadataManager)) {
            throw new OMException("Can not Complete MPU for file: " + keyName + " as there is already directory in the given path", OMException.ResultCodes.NOT_A_FILE);
        }
    }

    protected void logResult(OzoneManager ozoneManager, OzoneManagerProtocolProtos.MultipartUploadCompleteRequest multipartUploadCompleteRequest, List<OzoneManagerProtocolProtos.Part> partsList, Map<String, String> auditMap, String volumeName, String bucketName, String keyName, Exception exception, OMClientRequest.Result result) {
        auditMap.put("multipartList", partsList.toString().replaceAll("\\n", " "));
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("MultipartUpload Complete request is successful for Key: {} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumCompleteMultipartUploadFails();
                LOG.error("MultipartUpload Complete request failed for Key: {} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3MultipartUploadCommitRequest: {}", (Object)multipartUploadCompleteRequest);
            }
        }
    }

    protected OmKeyInfo getOmKeyInfo(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerProtocolProtos.KeyArgs keyArgs, String volumeName, String bucketName, String keyName, String multipartOpenKey, OMMetadataManager omMetadataManager, String ozoneKey, OmMultipartKeyInfo.PartKeyInfoMap partKeyInfoMap, List<OmKeyLocationInfo> partLocationInfos, long dataSize) throws IOException {
        OzoneManagerProtocolProtos.KeyInfo partKeyInfo = partKeyInfoMap.lastEntry().getPartKeyInfo();
        OmKeyInfo omKeyInfo = this.getOmKeyInfoFromKeyTable(ozoneKey, keyName, omMetadataManager);
        if (omKeyInfo == null) {
            OmKeyLocationInfoGroup keyLocationInfoGroup = new OmKeyLocationInfoGroup(0L, partLocationInfos, true);
            OmKeyInfo dbOpenKeyInfo = this.getOmKeyInfoFromOpenKeyTable(multipartOpenKey, keyName, omMetadataManager);
            OmKeyInfo.Builder builder = new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(dbOpenKeyInfo.getKeyName()).setReplicationConfig(ReplicationConfig.fromProto((HddsProtos.ReplicationType)partKeyInfo.getType(), (HddsProtos.ReplicationFactor)partKeyInfo.getFactor(), (HddsProtos.ECReplicationConfig)partKeyInfo.getEcReplicationConfig())).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(dataSize).setFileEncryptionInfo(dbOpenKeyInfo.getFileEncryptionInfo()).setOmKeyLocationInfos(Collections.singletonList(keyLocationInfoGroup)).setAcls(dbOpenKeyInfo.getAcls()).addAllMetadata(dbOpenKeyInfo.getMetadata()).addMetadata("ETag", this.multipartUploadedKeyHash(partKeyInfoMap));
            if (dbOpenKeyInfo.getObjectID() != 0L) {
                builder.setObjectID(dbOpenKeyInfo.getObjectID());
            }
            this.updatePrefixFSOInfo(dbOpenKeyInfo, builder);
            omKeyInfo = builder.build();
        } else {
            OmKeyInfo dbOpenKeyInfo = this.getOmKeyInfoFromOpenKeyTable(multipartOpenKey, keyName, omMetadataManager);
            if (dbOpenKeyInfo.getFileEncryptionInfo() != null) {
                omKeyInfo.setFileEncryptionInfo(dbOpenKeyInfo.getFileEncryptionInfo());
            }
            omKeyInfo.updateLocationInfoList(partLocationInfos, true, true);
            omKeyInfo.setModificationTime(keyArgs.getModificationTime());
            omKeyInfo.setDataSize(dataSize);
            omKeyInfo.setReplicationConfig(dbOpenKeyInfo.getReplicationConfig());
            if (dbOpenKeyInfo.getMetadata() != null) {
                omKeyInfo.setMetadata(dbOpenKeyInfo.getMetadata());
            }
            omKeyInfo.getMetadata().put("ETag", this.multipartUploadedKeyHash(partKeyInfoMap));
        }
        omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
        return omKeyInfo;
    }

    protected void updatePrefixFSOInfo(OmKeyInfo dbOpenKeyInfo, OmKeyInfo.Builder builder) {
    }

    protected String getDBOzoneKey(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        return omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
    }

    protected void addMissingParentsToCache(OmBucketInfo omBucketInfo, List<OmDirectoryInfo> missingParentInfos, OMMetadataManager omMetadataManager, long volumeId, long bucketId, long transactionLogIndex) throws IOException {
    }

    protected void addMultiPartToCache(OMMetadataManager omMetadataManager, String multipartOpenKey, OMFileRequest.OMPathInfoWithFSO pathInfoFSO, OmKeyInfo omKeyInfo, long transactionLogIndex) throws IOException {
    }

    protected OmKeyInfo getOmKeyInfoFromKeyTable(String dbOzoneKey, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbOzoneKey);
    }

    protected OmKeyInfo getOmKeyInfoFromOpenKeyTable(String dbMultipartKey, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbMultipartKey);
    }

    protected void addKeyTableCacheEntry(OMMetadataManager omMetadataManager, String dbOzoneKey, OmKeyInfo omKeyInfo, long transactionLogIndex) throws IOException {
        omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbOzoneKey), CacheValue.get((long)transactionLogIndex, (Object)omKeyInfo));
    }

    private int getPartsListSize(String requestedVolume, String requestedBucket, String keyName, String ozoneKey, List<Integer> partNumbers, List<OzoneManagerProtocolProtos.Part> partsList) throws OMException {
        int prevPartNumber = partsList.get(0).getPartNumber();
        int partsListSize = partsList.size();
        partNumbers.add(prevPartNumber);
        int i = 1;
        while (i < partsListSize) {
            int currentPartNumber = partsList.get(i).getPartNumber();
            if (prevPartNumber >= currentPartNumber) {
                LOG.error("PartNumber at index {} is {}, and its previous partNumber at index {} is {} for ozonekey is {}", new Object[]{i, currentPartNumber, i - 1, prevPartNumber, ozoneKey});
                throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + " because parts are in Invalid order.", OMException.ResultCodes.INVALID_PART_ORDER);
            }
            prevPartNumber = currentPartNumber;
            partNumbers.add(prevPartNumber);
            ++i;
        }
        return partsListSize;
    }

    private long getMultipartDataSize(String requestedVolume, String requestedBucket, String keyName, String ozoneKey, OmMultipartKeyInfo.PartKeyInfoMap partKeyInfoMap, int partsListSize, List<OmKeyLocationInfo> partLocationInfos, List<OzoneManagerProtocolProtos.Part> partsList, OzoneManager ozoneManager) throws OMException {
        long dataSize = 0L;
        int currentPartCount = 0;
        boolean eTagBasedValidationAvailable = partsList.stream().allMatch(OzoneManagerProtocolProtos.Part::hasETag);
        for (OzoneManagerProtocolProtos.Part part : partsList) {
            MultipartCommitRequestPart requestPart;
            ++currentPartCount;
            int partNumber = part.getPartNumber();
            OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = partKeyInfoMap.get(partNumber);
            MultipartCommitRequestPart multipartCommitRequestPart = requestPart = eTagBasedValidationAvailable ? this.eTagBasedValidator.apply(part, partKeyInfo) : this.partNameBasedValidator.apply(part, partKeyInfo);
            if (!requestPart.isValid()) {
                throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + ". Provided Part info is { " + requestPart.getRequestPartId() + ", " + partNumber + "}, whereas OM has eTag " + requestPart.getOmPartId(), OMException.ResultCodes.INVALID_PART);
            }
            OmKeyInfo currentPartKeyInfo = null;
            try {
                currentPartKeyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
            }
            catch (IOException ioe) {
                throw new OMException((Throwable)ioe, OMException.ResultCodes.INTERNAL_ERROR);
            }
            if (currentPartCount != partsListSize && currentPartKeyInfo.getDataSize() < (long)ozoneManager.getMinMultipartUploadPartSize()) {
                LOG.error("MultipartUpload: {} Part number: {} size {}  is less than minimum part size {}", new Object[]{ozoneKey, partKeyInfo.getPartNumber(), currentPartKeyInfo.getDataSize(), ozoneManager.getMinMultipartUploadPartSize()});
                throw new OMException(String.valueOf(S3MultipartUploadCompleteRequest.failureMessage(requestedVolume, requestedBucket, keyName)) + ". Entity too small.", OMException.ResultCodes.ENTITY_TOO_SMALL);
            }
            OmKeyLocationInfoGroup currentKeyInfoGroup = (OmKeyLocationInfoGroup)currentPartKeyInfo.getKeyLocationVersions().get(0);
            currentKeyInfoGroup.getLocationList().forEach(omKeyLocationInfo -> omKeyLocationInfo.setPartNumber(partNumber));
            partLocationInfos.addAll(currentKeyInfoGroup.getLocationList());
            dataSize += currentPartKeyInfo.getDataSize();
        }
        return dataSize;
    }

    private static String failureMessage(String volume, String bucket, String keyName) {
        return "Complete Multipart Upload Failed: volume: " + volume + " bucket: " + bucket + " key: " + keyName;
    }

    private void updateCache(OMMetadataManager omMetadataManager, String dbBucketKey, @Nullable OmBucketInfo omBucketInfo, String dbOzoneKey, String dbMultipartOpenKey, String dbMultipartKey, OmKeyInfo omKeyInfo, long transactionLogIndex) throws IOException {
        this.addKeyTableCacheEntry(omMetadataManager, dbOzoneKey, omKeyInfo, transactionLogIndex);
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbMultipartOpenKey), CacheValue.get((long)transactionLogIndex));
        omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)dbMultipartKey), CacheValue.get((long)transactionLogIndex));
        if (omBucketInfo != null) {
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)dbBucketKey), CacheValue.get((long)transactionLogIndex, (Object)omBucketInfo));
        }
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload)
    public static OzoneManagerProtocolProtos.OMRequest disallowCompleteMultiPartUploadWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getCompleteMultiPartUploadRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload)
    public static OzoneManagerProtocolProtos.OMRequest blockMPUCompleteWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getCompleteMultiPartUploadRequest().hasKeyArgs() && (keyArgs = req.getCompleteMultiPartUploadRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private String multipartUploadedKeyHash(OmMultipartKeyInfo.PartKeyInfoMap partsList) {
        StringBuffer keysConcatenated = new StringBuffer();
        for (OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo : partsList) {
            String partPropertyToComputeHash = (String)KeyValueUtil.getFromProtobuf((List)partKeyInfo.getPartKeyInfo().getMetadataList()).get("ETag");
            if (partPropertyToComputeHash == null) {
                partPropertyToComputeHash = partKeyInfo.getPartName();
            }
            keysConcatenated.append(partPropertyToComputeHash);
        }
        return String.valueOf(DigestUtils.md5Hex((String)keysConcatenated.toString())) + "-" + partsList.size();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3MultipartUploadCompleteRequest.java", S3MultipartUploadCompleteRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCompleteRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 123);
    }

    private static class MultipartCommitRequestPart {
        private String requestPartId;
        private String omPartId;
        private boolean isValid;

        MultipartCommitRequestPart(String requestPartId, String omPartId, boolean isValid) {
            this.requestPartId = requestPartId;
            this.omPartId = omPartId;
            this.isValid = isValid;
        }

        public String getRequestPartId() {
            return this.requestPartId;
        }

        public String getOmPartId() {
            return this.omPartId;
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

