/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMRecoverLeaseResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRecoverLeaseRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private String volumeName;
    private String bucketName;
    private String keyName;
    private OmKeyInfo keyInfo;
    private String dbFileKey;
    private OMMetadataManager omMetadataManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMRecoverLeaseRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMRecoverLeaseRequest.class);
    }

    public OMRecoverLeaseRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        OzoneManagerProtocolProtos.RecoverLeaseRequest recoverLeaseRequest = this.getOmRequest().getRecoverLeaseRequest();
        Preconditions.checkNotNull((Object)recoverLeaseRequest);
        this.volumeName = recoverLeaseRequest.getVolumeName();
        this.bucketName = recoverLeaseRequest.getBucketName();
        this.keyName = recoverLeaseRequest.getKeyName();
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.OMRequest request = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.RecoverLeaseRequest recoverLeaseRequest = request.getRecoverLeaseRequest();
        String keyPath = recoverLeaseRequest.getKeyName();
        String normalizedKeyPath = OMRecoverLeaseRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        return request.toBuilder().setRecoverLeaseRequest(recoverLeaseRequest.toBuilder().setKeyName(normalizedKeyPath)).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        Exception exception;
        OMClientResponse omClientResponse;
        LinkedHashMap<String, String> auditMap;
        block11: {
            OzoneManagerProtocolProtos.RecoverLeaseRequest recoverLeaseRequest = this.getOmRequest().getRecoverLeaseRequest();
            Preconditions.checkNotNull((Object)recoverLeaseRequest);
            auditMap = new LinkedHashMap<String, String>();
            auditMap.put("volume", this.volumeName);
            auditMap.put("bucket", this.bucketName);
            auditMap.put("key", this.keyName);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            this.omMetadataManager = ozoneManager.getMetadataManager();
            omClientResponse = null;
            exception = null;
            OMMetrics omMetrics = ozoneManager.getMetrics();
            boolean acquiredLock = false;
            try {
                try {
                    this.checkKeyAcls(ozoneManager, this.volumeName, this.bucketName, this.keyName, IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
                    this.mergeOmLockDetails(this.omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(this.omMetadataManager, this.volumeName, this.bucketName);
                    String openKeyEntryName = this.doWork(ozoneManager, transactionLogIndex);
                    boolean responseCode = true;
                    omResponse.setRecoverLeaseResponse(OzoneManagerProtocolProtos.RecoverLeaseResponse.newBuilder().setResponse(responseCode).build()).setCmdType(OzoneManagerProtocolProtos.Type.RecoverLease);
                    omClientResponse = new OMRecoverLeaseResponse(omResponse.build(), this.getBucketLayout(), this.keyInfo, this.dbFileKey, openKeyEntryName);
                    omMetrics.incNumRecoverLease();
                    LOG.debug("Key recovered. Volume:{}, Bucket:{}, Key:{}", new Object[]{this.volumeName, this.bucketName, this.keyName});
                }
                catch (IOException | InvalidPathException ex) {
                    LOG.error("Fail for recovering lease. Volume:{}, Bucket:{}, Key:{}", new Object[]{this.volumeName, this.bucketName, this.keyName, ex});
                    exception = ex;
                    omMetrics.incNumRecoverLeaseFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.RecoverLease);
                    omClientResponse = new OMRecoverLeaseResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredLock) {
                        this.mergeOmLockDetails(this.omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(this.omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(this.omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{this.volumeName, this.bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.RECOVER_LEASE, auditMap, exception, this.getOmRequest().getUserInfo()));
        return omClientResponse;
    }

    private String doWork(OzoneManager ozoneManager, long transactionLogIndex) throws IOException {
        long volumeId = this.omMetadataManager.getVolumeId(this.volumeName);
        long bucketId = this.omMetadataManager.getBucketId(this.volumeName, this.bucketName);
        Iterator<Path> pathComponents = Paths.get(this.keyName, new String[0]).iterator();
        long parentID = OMFileRequest.getParentID(volumeId, bucketId, pathComponents, this.keyName, this.omMetadataManager, "Cannot recover file : " + this.keyName + " as parent directory doesn't exist");
        String fileName = OzoneFSUtils.getFileName((String)this.keyName);
        this.dbFileKey = this.omMetadataManager.getOzonePathKey(volumeId, bucketId, parentID, fileName);
        this.keyInfo = this.getKey(this.dbFileKey);
        if (this.keyInfo == null) {
            throw new OMException("Key:" + this.keyName + " not found", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        String clientId = (String)this.keyInfo.getMetadata().remove("hsyncClientId");
        if (clientId == null) {
            LOG.warn("Key:" + this.keyName + " is already closed");
            return null;
        }
        String openFileDBKey = this.omMetadataManager.getOpenFileName(volumeId, bucketId, parentID, fileName, Long.parseLong(clientId));
        if (openFileDBKey != null) {
            this.commitKey(this.dbFileKey, this.keyInfo, fileName, ozoneManager, transactionLogIndex);
            this.removeOpenKey(openFileDBKey, fileName, transactionLogIndex);
        }
        return openFileDBKey;
    }

    private OmKeyInfo getKey(String dbOzoneKey) throws IOException {
        return (OmKeyInfo)this.omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbOzoneKey);
    }

    private void commitKey(String dbOzoneKey, OmKeyInfo omKeyInfo, String fileName, OzoneManager ozoneManager, long transactionLogIndex) throws IOException {
        omKeyInfo.setModificationTime(Time.now());
        omKeyInfo.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
        OMFileRequest.addFileTableCacheEntry(this.omMetadataManager, dbOzoneKey, omKeyInfo, fileName, transactionLogIndex);
    }

    private void removeOpenKey(String openKeyName, String fileName, long transactionLogIndex) {
        OMFileRequest.addOpenFileTableCacheEntry(this.omMetadataManager, openKeyName, null, fileName, transactionLogIndex);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMRecoverLeaseRequest.java", OMRecoverLeaseRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.file.OMRecoverLeaseRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 92);
    }
}

