/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequest;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeySetTimesRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeySetTimesRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeysDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeysRenameRequest;
import org.apache.hadoop.ozone.om.request.key.OmKeysDeleteRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCompleteRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCompleteRequestWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BucketLayoutAwareOMKeyRequestFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BucketLayoutAwareOMKeyRequestFactory.class);
    static final HashMap<String, Class<? extends OMKeyRequest>> OM_KEY_REQUEST_CLASSES = new HashMap();

    static {
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CreateDirectory, OMDirectoryCreateRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CreateDirectory, OMDirectoryCreateRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CreateFile, OMFileCreateRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CreateFile, OMFileCreateRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CreateKey, OMKeyCreateRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CreateKey, OMKeyCreateRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.AllocateBlock, OMAllocateBlockRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.AllocateBlock, OMAllocateBlockRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CommitKey, OMKeyCommitRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CommitKey, OMKeyCommitRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.DeleteKey, OMKeyDeleteRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.DeleteKey, OMKeyDeleteRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.DeleteKeys, OMKeysDeleteRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.DeleteKeys, OmKeysDeleteRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.RenameKey, OMKeyRenameRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.RenameKey, OMKeyRenameRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.RenameKeys, OMKeysRenameRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload, S3InitiateMultipartUploadRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload, S3InitiateMultipartUploadRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload, S3MultipartUploadCommitPartRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload, S3MultipartUploadCommitPartRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.AbortMultiPartUpload, S3MultipartUploadAbortRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.AbortMultiPartUpload, S3MultipartUploadAbortRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload, S3MultipartUploadCompleteRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload, S3MultipartUploadCompleteRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.SetTimes, OMKeySetTimesRequest.class, BucketLayout.OBJECT_STORE);
        BucketLayoutAwareOMKeyRequestFactory.addRequestClass(OzoneManagerProtocolProtos.Type.SetTimes, OMKeySetTimesRequestWithFSO.class, BucketLayout.FILE_SYSTEM_OPTIMIZED);
    }

    private BucketLayoutAwareOMKeyRequestFactory() {
    }

    public static OMKeyRequest createRequest(String volumeName, String bucketName, OzoneManagerProtocolProtos.OMRequest omRequest, OMMetadataManager omMetadataManager) throws IOException {
        if (StringUtils.isBlank((CharSequence)volumeName)) {
            throw new OMException("Invalid, volume name is empty", OMException.ResultCodes.INVALID_VOLUME_NAME);
        }
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new OMException("Invalid, Bucket name is empty", OMException.ResultCodes.INVALID_BUCKET_NAME);
        }
        BucketLayout bucketLayout = OzoneManagerUtils.getBucketLayout(omMetadataManager, volumeName, bucketName);
        OzoneManagerProtocolProtos.Type requestType = omRequest.getCmdType();
        String classKey = BucketLayoutAwareOMKeyRequestFactory.getKey(requestType, bucketLayout);
        if (OM_KEY_REQUEST_CLASSES.containsKey(classKey)) {
            try {
                return BucketLayoutAwareOMKeyRequestFactory.getRequestInstanceFromMap(omRequest, classKey, bucketLayout);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String errMsg = "Exception while instantiating OMKeyRequest of type " + requestType + " for bucket layout " + bucketLayout + ". Please check the OMKeyRequest class constructor.";
                LOG.error(errMsg, (Throwable)e);
                throw new OMException(errMsg, OMException.ResultCodes.INTERNAL_ERROR);
            }
        }
        throw new OMException("Request type " + requestType + " not supported with bucket layout " + bucketLayout, OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
    }

    static void addRequestClass(OzoneManagerProtocolProtos.Type requestType, Class<? extends OMKeyRequest> requestClass, BucketLayout associatedBucketLayout) {
        OM_KEY_REQUEST_CLASSES.put(BucketLayoutAwareOMKeyRequestFactory.getKey(requestType, associatedBucketLayout), requestClass);
    }

    @NotNull
    static OMKeyRequest getRequestInstanceFromMap(OzoneManagerProtocolProtos.OMRequest omRequest, String classKey, BucketLayout bucketLayout) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends OMKeyRequest> declaredConstructor = OM_KEY_REQUEST_CLASSES.get(classKey).getDeclaredConstructor(OzoneManagerProtocolProtos.OMRequest.class, BucketLayout.class);
        return declaredConstructor.newInstance(omRequest, bucketLayout);
    }

    static String getKey(OzoneManagerProtocolProtos.Type requestType, BucketLayout bucketLayout) {
        return String.valueOf(requestType.toString()) + (bucketLayout.isFileSystemOptimized() ? bucketLayout : "");
    }
}

