/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeManagerImpl
implements VolumeManager {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeManagerImpl.class);
    private final OMMetadataManager metadataManager;

    public VolumeManagerImpl(OMMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        OmVolumeArgs omVolumeArgs;
        Preconditions.checkNotNull((Object)volume);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            omVolumeArgs = volumeArgs;
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.warn("Info volume failed for volume:{}", (Object)volume, (Object)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return omVolumeArgs;
    }

    @Override
    public List<OmVolumeArgs> listVolumes(String userName, String prefix, String startKey, int maxKeys) throws IOException {
        List list;
        block4: {
            boolean acquired = false;
            if (userName != null) {
                acquired = this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName}).isLockAcquired();
            }
            try {
                list = this.metadataManager.listVolumes(userName, prefix, startKey, maxKeys);
                if (!acquired) break block4;
            }
            catch (Throwable throwable) {
                if (acquired) {
                    this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
                }
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
        }
        return list;
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
            throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            list = volumeArgs.getAcls();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for volume:{}", (Object)volume, (Object)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return list;
    }

    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        boolean bl;
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        String volume = ozObject.getVolumeName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            boolean hasAccess = OzoneAclUtil.checkAclRights((List)volumeArgs.getAcls(), (RequestContext)context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("user:{} has access rights for volume:{} :{} ", new Object[]{context.getClientUgi(), ozObject.getVolumeName(), hasAccess});
            }
            bl = hasAccess;
        }
        catch (IOException ex) {
            try {
                if (ex instanceof OMException) {
                    throw (OMException)((Object)ex);
                }
                LOG.error("Check access operation failed for volume:{}", (Object)volume, (Object)ex);
                throw new OMException("Check access operation failed for volume:" + volume, (Throwable)ex, OMException.ResultCodes.INTERNAL_ERROR);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return bl;
    }
}

