/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketManagerImpl
implements BucketManager {
    private static final Logger LOG = LoggerFactory.getLogger(BucketManagerImpl.class);
    private final OzoneManager ozoneManager;
    private final OMMetadataManager metadataManager;

    public BucketManagerImpl(OzoneManager ozoneManager, OMMetadataManager metadataManager) {
        this.ozoneManager = ozoneManager;
        this.metadataManager = metadataManager;
    }

    @Override
    public OmBucketInfo getBucketInfo(String volumeName, String bucketName) throws IOException {
        OmBucketInfo omBucketInfo;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            omBucketInfo = OzoneManagerUtils.getBucketInfo(this.metadataManager, volumeName, bucketName);
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Exception while getting bucket info for bucket: {}", (Object)bucketName, (Object)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omBucketInfo;
    }

    @Override
    public List<OmBucketInfo> listBuckets(String volumeName, String startBucket, String bucketPrefix, int maxNumOfBuckets, boolean hasSnapshot) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        return this.metadataManager.listBuckets(volumeName, startBucket, bucketPrefix, maxNumOfBuckets, hasSnapshot);
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.BUCKET)) {
            throw new IllegalArgumentException("Unexpected argument passed to BucketManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            String dbBucketKey = this.metadataManager.getBucketKey(volume, bucket);
            OmBucketInfo bucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)dbBucketKey);
            if (bucketInfo == null) {
                LOG.debug("Bucket:{}/{} does not exist", (Object)volume, (Object)bucket);
                throw new OMException("Bucket " + bucket + " is not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            list = bucketInfo.getAcls();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for bucket:{}/{}.", new Object[]{volume, bucket, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return list;
    }

    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        boolean bl;
        boolean bucketNeedResolved;
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        String volume = ozObject.getVolumeName();
        String bucket = ozObject.getBucketName();
        boolean bl2 = bucketNeedResolved = ozObject.getResourceType() == OzoneObj.ResourceType.BUCKET && context.getAclRights() != IAccessAuthorizer.ACLType.DELETE && context.getAclRights() != IAccessAuthorizer.ACLType.READ_ACL && context.getAclRights() != IAccessAuthorizer.ACLType.READ;
        if (bucketNeedResolved || ozObject.getResourceType() == OzoneObj.ResourceType.KEY) {
            try {
                ResolvedBucket resolvedBucket = this.ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)ozObject.getVolumeName(), (Object)ozObject.getBucketName()));
                volume = resolvedBucket.realVolume();
                bucket = resolvedBucket.realBucket();
            }
            catch (IOException e) {
                if (e instanceof OMException && ((OMException)((Object)e)).getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                    LOG.warn("checkAccess on non-exist source bucket Volume:{} Bucket:{}.", (Object)volume, (Object)bucket);
                }
                throw new OMException(e.getMessage(), OMException.ResultCodes.INTERNAL_ERROR);
            }
        }
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            String dbBucketKey = this.metadataManager.getBucketKey(volume, bucket);
            OmBucketInfo bucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)dbBucketKey);
            if (bucketInfo == null) {
                LOG.debug("Bucket:{}/{} does not exist", (Object)volume, (Object)bucket);
                throw new OMException("Bucket " + bucket + " is not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            boolean hasAccess = OzoneAclUtil.checkAclRights((List)bucketInfo.getAcls(), (RequestContext)context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("user:{} has access rights for bucket:{} :{} ", new Object[]{context.getClientUgi(), ozObject.getBucketName(), hasAccess});
            }
            bl = hasAccess;
        }
        catch (IOException ex) {
            try {
                if (ex instanceof OMException) {
                    throw (OMException)((Object)ex);
                }
                LOG.error("CheckAccess operation failed for bucket:{}/{}.", new Object[]{volume, bucket, ex});
                throw new OMException("Check access operation failed for bucket:" + bucket, (Throwable)ex, OMException.ResultCodes.INTERNAL_ERROR);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return bl;
    }
}

