/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBMetrics;
import org.apache.hadoop.hdds.utils.db.RDBSstFileLoader;
import org.apache.hadoop.hdds.utils.db.RDBSstFileWriter;
import org.apache.hadoop.hdds.utils.db.RDBStoreByteArrayIterator;
import org.apache.hadoop.hdds.utils.db.RDBStoreCodecBufferIterator;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RDBTable
implements Table<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(RDBTable.class);
    private final RocksDatabase db;
    private final RocksDatabase.ColumnFamily family;
    private final RDBMetrics rdbMetrics;

    RDBTable(RocksDatabase db, RocksDatabase.ColumnFamily family, RDBMetrics rdbMetrics) {
        this.db = db;
        this.family = family;
        this.rdbMetrics = rdbMetrics;
    }

    public RocksDatabase.ColumnFamily getColumnFamily() {
        return this.family;
    }

    @Override
    void put(ByteBuffer key, ByteBuffer value) throws IOException {
        this.db.put(this.family, key, value);
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        this.db.put(this.family, key, value);
    }

    @Override
    void putWithBatch(BatchOperation batch, CodecBuffer key, CodecBuffer value) throws IOException {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("Unexpected batch class: " + batch.getClass().getSimpleName());
        }
        ((RDBBatchOperation)batch).put(this.family, key, value);
    }

    @Override
    public void putWithBatch(BatchOperation batch, byte[] key, byte[] value) throws IOException {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).put(this.family, key, value);
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (TableIterator<byte[], Table.KeyValue<byte[], byte[]>> keyIter = this.iterator();){
            keyIter.seekToFirst();
            boolean bl = !keyIter.hasNext();
            return bl;
        }
    }

    @Override
    public boolean isExist(byte[] key) throws IOException {
        boolean exists;
        this.rdbMetrics.incNumDBKeyMayExistChecks();
        Supplier<byte[]> holder = this.db.keyMayExist(this.family, key);
        if (holder == null) {
            return false;
        }
        byte[] value = holder.get();
        if (value != null) {
            return true;
        }
        boolean bl = exists = this.get(key) != null;
        if (!exists) {
            this.rdbMetrics.incNumDBKeyMayExistMisses();
        }
        return exists;
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        this.rdbMetrics.incNumDBKeyGets();
        return this.db.get(this.family, key);
    }

    Integer get(ByteBuffer key, ByteBuffer outValue) throws IOException {
        return this.db.get(this.family, key, outValue);
    }

    @Override
    public byte[] getSkipCache(byte[] bytes) throws IOException {
        return this.get(bytes);
    }

    @Override
    public byte[] getIfExist(byte[] key) throws IOException {
        this.rdbMetrics.incNumDBKeyGetIfExistChecks();
        Supplier<byte[]> value = this.db.keyMayExist(this.family, key);
        if (value == null) {
            return null;
        }
        if (value.get() != null) {
            return value.get();
        }
        this.rdbMetrics.incNumDBKeyGetIfExistGets();
        byte[] val = this.get(key);
        if (val == null) {
            this.rdbMetrics.incNumDBKeyGetIfExistMisses();
        }
        return val;
    }

    Integer getIfExist(ByteBuffer key, ByteBuffer outValue) throws IOException {
        this.rdbMetrics.incNumDBKeyGetIfExistChecks();
        Supplier<Integer> value = this.db.keyMayExist(this.family, key, outValue.duplicate());
        if (value == null) {
            return null;
        }
        if (value.get() != null) {
            return value.get();
        }
        this.rdbMetrics.incNumDBKeyGetIfExistGets();
        Integer val = this.get(key, outValue);
        if (val == null) {
            this.rdbMetrics.incNumDBKeyGetIfExistMisses();
        }
        return val;
    }

    @Override
    public void delete(byte[] key) throws IOException {
        this.db.delete(this.family, key);
    }

    @Override
    public void delete(ByteBuffer key) throws IOException {
        this.db.delete(this.family, key);
    }

    @Override
    public void deleteRange(byte[] beginKey, byte[] endKey) throws IOException {
        this.db.deleteRange(this.family, beginKey, endKey);
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, byte[] key) throws IOException {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).delete(this.family, key);
    }

    @Override
    public TableIterator<byte[], Table.KeyValue<byte[], byte[]>> iterator() throws IOException {
        return this.iterator((byte[])null);
    }

    @Override
    public TableIterator<byte[], Table.KeyValue<byte[], byte[]>> iterator(byte[] prefix) throws IOException {
        return new RDBStoreByteArrayIterator(this.db.newIterator(this.family, false), this, prefix);
    }

    @Override
    TableIterator<CodecBuffer, Table.KeyValue<CodecBuffer, CodecBuffer>> iterator(CodecBuffer prefix) throws IOException {
        return new RDBStoreCodecBufferIterator(this.db.newIterator(this.family, false), this, prefix);
    }

    @Override
    public String getName() {
        return this.family.getName();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public long getEstimatedKeyCount() throws IOException {
        return this.db.estimateNumKeys(this.family);
    }

    @Override
    public List<Table.KeyValue<byte[], byte[]>> getRangeKVs(byte[] startKey, int count, byte[] prefix, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, false, prefix, filters);
    }

    @Override
    public List<Table.KeyValue<byte[], byte[]>> getSequentialRangeKVs(byte[] startKey, int count, byte[] prefix, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, true, prefix, filters);
    }

    @Override
    public void deleteBatchWithPrefix(BatchOperation batch, byte[] prefix) throws IOException {
        try (TableIterator<byte[], Table.KeyValue<byte[], byte[]>> iter = this.iterator(prefix);){
            while (iter.hasNext()) {
                this.deleteWithBatch(batch, (byte[])((Table.KeyValue)iter.next()).getKey());
            }
        }
    }

    @Override
    public void dumpToFileWithPrefix(File externalFile, byte[] prefix) throws IOException {
        try (TableIterator<byte[], Table.KeyValue<byte[], byte[]>> iter = this.iterator(prefix);
             RDBSstFileWriter fileWriter = new RDBSstFileWriter();){
            fileWriter.open(externalFile);
            while (iter.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)iter.next();
                fileWriter.put((byte[])entry.getKey(), (byte[])entry.getValue());
            }
        }
    }

    @Override
    public void loadFromFile(File externalFile) throws IOException {
        try (RDBSstFileLoader fileLoader = new RDBSstFileLoader(this.db, this.family);){
            fileLoader.load(externalFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Table.KeyValue<byte[], byte[]>> getRangeKVs(byte[] startKey, int count, boolean sequential, byte[] prefix, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        block27: {
            block28: {
                block31: {
                    start = System.currentTimeMillis();
                    if (count < 0) {
                        throw new IllegalArgumentException("Invalid count given " + count + ", count must be greater than 0");
                    }
                    result = new ArrayList<Table.KeyValue<byte[], byte[]>>();
                    try {
                        block29: {
                            block30: {
                                it = this.iterator(prefix);
                                var10_10 = null;
                                try {
                                    if (startKey == null) {
                                        it.seekToFirst();
                                    } else {
                                        if (prefix != null && startKey.length <= prefix.length || this.get(startKey) != null) break block27;
                                        var11_11 = result;
                                        if (it == null) break block28;
                                        if (var10_10 == null) break block29;
                                        break block30;
                                    }
lbl17:
                                    // 2 sources

                                    while (true) {
                                        if (!it.hasNext() || result.size() >= count) break block31;
                                        currentEntry = (Table.KeyValue)it.next();
                                        currentKey = (byte[])currentEntry.getKey();
                                        if (filters == null) {
                                            result.add(currentEntry);
                                            continue;
                                        }
                                        if (Arrays.stream(filters).allMatch((Predicate<MetadataKeyFilters.MetadataKeyFilter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getRangeKVs$0(byte[] org.apache.hadoop.hdds.utils.MetadataKeyFilters$MetadataKeyFilter ), (Lorg/apache/hadoop/hdds/utils/MetadataKeyFilters$MetadataKeyFilter;)Z)((byte[])currentKey))) {
                                            result.add(currentEntry);
                                            continue;
                                        }
                                        if (result.size() <= 0 || !sequential) continue;
                                        break block31;
                                        break;
                                    }
                                }
                                catch (Throwable currentEntry) {
                                    var10_10 = currentEntry;
                                    throw currentEntry;
                                }
                                catch (Throwable var22_30) {
                                    throw var22_30;
                                }
                            }
                            try {
                                it.close();
                            }
                            catch (Throwable var12_16) {
                                var10_10.addSuppressed(var12_16);
                            }
                            break block28;
                        }
                        it.close();
                    }
                    catch (Throwable var24_34) {
                        end = System.currentTimeMillis();
                        timeConsumed = end - start;
                        if (RDBTable.LOG.isDebugEnabled() == false) throw var24_34;
                        if (filters != null) {
                            for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                                scanned = filter.getKeysScannedNum();
                                hinted = filter.getKeysHintedNum();
                                if (scanned <= 0 && hinted <= 0) continue;
                                RDBTable.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                            }
                        }
                        RDBTable.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                        throw var24_34;
                    }
                }
                end = System.currentTimeMillis();
                timeConsumed = end - start;
                if (RDBTable.LOG.isDebugEnabled() == false) return result;
                if (filters != null) {
                    for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                        scanned = filter.getKeysScannedNum();
                        hinted = filter.getKeysHintedNum();
                        if (scanned <= 0 && hinted <= 0) continue;
                        RDBTable.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                    }
                }
                RDBTable.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                return result;
            }
            end = System.currentTimeMillis();
            timeConsumed = end - start;
            if (RDBTable.LOG.isDebugEnabled() == false) return var11_11;
            if (filters != null) {
                for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                    scanned = filter.getKeysScannedNum();
                    hinted = filter.getKeysHintedNum();
                    if (scanned <= 0 && hinted <= 0) continue;
                    RDBTable.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                }
            }
            RDBTable.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
            return var11_11;
        }
        it.seek(startKey);
        ** while (true)
    }

    private static /* synthetic */ boolean lambda$getRangeKVs$0(byte[] currentKey, MetadataKeyFilters.MetadataKeyFilter entry) {
        return entry.filterKey(null, currentKey, null);
    }
}

