/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.utils.db.RDBTable;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RDBStoreAbstractIterator<RAW>
implements TableIterator<RAW, Table.KeyValue<RAW, RAW>> {
    private static final Logger LOG = LoggerFactory.getLogger(RDBStoreAbstractIterator.class);
    private final ManagedRocksIterator rocksDBIterator;
    private final RDBTable rocksDBTable;
    private Table.KeyValue<RAW, RAW> currentEntry;
    private final RAW prefix;

    RDBStoreAbstractIterator(ManagedRocksIterator iterator, RDBTable table, RAW prefix) {
        this.rocksDBIterator = iterator;
        this.rocksDBTable = table;
        this.prefix = prefix;
    }

    abstract RAW key();

    abstract Table.KeyValue<RAW, RAW> getKeyValue();

    abstract void seek0(RAW var1);

    abstract void delete(RAW var1) throws IOException;

    abstract boolean startsWithPrefix(RAW var1);

    final ManagedRocksIterator getRocksDBIterator() {
        return this.rocksDBIterator;
    }

    final RDBTable getRocksDBTable() {
        return this.rocksDBTable;
    }

    final RAW getPrefix() {
        return this.prefix;
    }

    @Override
    public final void forEachRemaining(Consumer<? super Table.KeyValue<RAW, RAW>> action) {
        while (this.hasNext()) {
            action.accept((Table.KeyValue<RAW, RAW>)this.next());
        }
    }

    private void setCurrentEntry() {
        this.currentEntry = ((RocksIterator)this.rocksDBIterator.get()).isValid() ? this.getKeyValue() : null;
    }

    @Override
    public final boolean hasNext() {
        return ((RocksIterator)this.rocksDBIterator.get()).isValid() && (this.prefix == null || this.startsWithPrefix(this.key()));
    }

    @Override
    public final Table.KeyValue<RAW, RAW> next() {
        this.setCurrentEntry();
        if (this.currentEntry != null) {
            ((RocksIterator)this.rocksDBIterator.get()).next();
            return this.currentEntry;
        }
        throw new NoSuchElementException("RocksDB Store has no more elements");
    }

    @Override
    public final void seekToFirst() {
        if (this.prefix == null) {
            ((RocksIterator)this.rocksDBIterator.get()).seekToFirst();
        } else {
            this.seek0(this.prefix);
        }
        this.setCurrentEntry();
    }

    @Override
    public final void seekToLast() {
        if (this.prefix != null) {
            throw new UnsupportedOperationException("seekToLast: prefix != null");
        }
        ((RocksIterator)this.rocksDBIterator.get()).seekToLast();
        this.setCurrentEntry();
    }

    @Override
    public final Table.KeyValue<RAW, RAW> seek(RAW key) {
        this.seek0(key);
        this.setCurrentEntry();
        return this.currentEntry;
    }

    @Override
    public final void removeFromDB() throws IOException {
        if (this.rocksDBTable == null) {
            throw new UnsupportedOperationException("remove");
        }
        if (this.currentEntry != null) {
            this.delete(this.currentEntry.getKey());
        } else {
            LOG.info("Failed to removeFromDB: currentEntry == null");
        }
    }

    @Override
    public void close() {
        this.rocksDBIterator.close();
    }
}

