/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDBCheckpointUtils {
    static final Logger LOG = LoggerFactory.getLogger(RDBCheckpointUtils.class);
    private static final Duration POLL_DELAY_DURATION = Duration.ZERO;
    private static final Duration POLL_INTERVAL_DURATION = Duration.ofMillis(100L);
    private static final Duration POLL_MAX_DURATION = Duration.ofSeconds(20L);

    private RDBCheckpointUtils() {
    }

    public static boolean waitForCheckpointDirectoryExist(File file, Duration maxWaitTimeout) {
        Instant start = Instant.now();
        try {
            Awaitility.with().atMost(maxWaitTimeout).pollDelay(POLL_DELAY_DURATION).pollInterval(POLL_INTERVAL_DURATION).await().until(file::exists);
            LOG.info("Waited for {} milliseconds for checkpoint directory {} availability.", (Object)Duration.between(start, Instant.now()).toMillis(), (Object)file.getAbsoluteFile());
            return true;
        }
        catch (ConditionTimeoutException exception) {
            LOG.info("Checkpoint directory: {} didn't get created in {} secs.", (Object)maxWaitTimeout.getSeconds(), (Object)file.getAbsolutePath());
            return false;
        }
    }

    public static boolean waitForCheckpointDirectoryExist(File file) throws IOException {
        return RDBCheckpointUtils.waitForCheckpointDirectoryExist(file, POLL_MAX_DURATION);
    }
}

