/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;

public final class ByteStringCodec
implements Codec<ByteString> {
    private static final ByteStringCodec INSTANCE = new ByteStringCodec();

    public static ByteStringCodec get() {
        return INSTANCE;
    }

    private ByteStringCodec() {
    }

    public boolean supportCodecBuffer() {
        return true;
    }

    public CodecBuffer toCodecBuffer(@Nonnull ByteString object, CodecBuffer.Allocator allocator) {
        if (allocator.isDirect() && !object.asReadOnlyByteBuffer().isDirect()) {
            return ((CodecBuffer)allocator.apply(object.size())).put(object.asReadOnlyByteBuffer());
        }
        return CodecBuffer.wrap((ByteString)object);
    }

    public ByteString fromCodecBuffer(@Nonnull CodecBuffer buffer) {
        Object wrapped = buffer.getWrapped();
        return wrapped instanceof ByteString ? (ByteString)wrapped : ByteString.copyFrom((ByteBuffer)buffer.asReadOnlyByteBuffer());
    }

    public byte[] toPersistedFormat(ByteString object) {
        if (object == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return object.toByteArray();
    }

    public ByteString fromPersistedFormat(byte[] rawData) {
        if (rawData == null) {
            return ByteString.EMPTY;
        }
        return ByteString.copyFrom((byte[])rawData);
    }

    public ByteString copyObject(ByteString object) {
        if (object == null) {
            return ByteString.EMPTY;
        }
        return object;
    }
}

