/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

public class OzoneAdmins {
    private volatile Set<String> adminUsernames;
    private final Set<String> adminGroups;

    public OzoneAdmins(Collection<String> adminUsernames) {
        this(adminUsernames, null);
    }

    public OzoneAdmins(Collection<String> adminUsernames, Collection<String> adminGroups) {
        this.setAdminUsernames(adminUsernames);
        this.adminGroups = adminGroups != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(adminGroups)) : Collections.emptySet();
    }

    public static OzoneAdmins getOzoneAdmins(String starterUser, OzoneConfiguration configuration) {
        Collection<String> adminUserNames = OzoneAdmins.getOzoneAdminsFromConfig(configuration, starterUser);
        Collection<String> adminGroupNames = OzoneAdmins.getOzoneAdminsGroupsFromConfig(configuration);
        return new OzoneAdmins(adminUserNames, adminGroupNames);
    }

    public static OzoneAdmins getReadonlyAdmins(OzoneConfiguration configuration) {
        Collection<String> omReadOnlyAdmins = OzoneAdmins.getOzoneReadOnlyAdminsFromConfig(configuration);
        Collection<String> omReadOnlyAdminsGroups = OzoneAdmins.getOzoneReadOnlyAdminsGroupsFromConfig(configuration);
        return new OzoneAdmins(omReadOnlyAdmins, omReadOnlyAdminsGroups);
    }

    public void checkAdminUserPrivilege(UserGroupInformation ugi) throws AccessControlException {
        if (ugi != null && !this.isAdmin(ugi)) {
            throw new AccessControlException("Access denied for user " + ugi.getUserName() + ". Superuser privilege is required.");
        }
    }

    private boolean hasAdminGroup(Collection<String> userGroups) {
        return !Sets.intersection(this.adminGroups, new LinkedHashSet<String>(userGroups)).isEmpty();
    }

    public boolean isAdmin(UserGroupInformation user) {
        return user != null && (this.adminUsernames.contains("*") || this.adminUsernames.contains(user.getShortUserName()) || this.hasAdminGroup(user.getGroups()));
    }

    public Collection<String> getAdminGroups() {
        return this.adminGroups;
    }

    public Set<String> getAdminUsernames() {
        return this.adminUsernames;
    }

    public void setAdminUsernames(Collection<String> adminUsernames) {
        this.adminUsernames = adminUsernames != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(adminUsernames)) : Collections.emptySet();
    }

    public static Collection<String> getOzoneAdminsFromConfig(OzoneConfiguration conf, String starterUser) {
        Collection ozAdmins = conf.getTrimmedStringCollection("ozone.administrators");
        if (!ozAdmins.contains(starterUser)) {
            ozAdmins.add(starterUser);
        }
        return ozAdmins;
    }

    public static Collection<String> getOzoneAdminsGroupsFromConfig(OzoneConfiguration configuration) {
        return configuration.getTrimmedStringCollection("ozone.administrators.groups");
    }

    public static Collection<String> getOzoneReadOnlyAdminsFromConfig(OzoneConfiguration conf) {
        return conf.getTrimmedStringCollection("ozone.readonly.administrators");
    }

    public static Collection<String> getOzoneReadOnlyAdminsGroupsFromConfig(OzoneConfiguration conf) {
        return conf.getTrimmedStringCollection("ozone.readonly.administrators.groups");
    }
}

