/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.crl;

import com.google.protobuf.MessageLite;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.crl.CRLCodec;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.jetbrains.annotations.NotNull;

public final class CRLInfo
implements Comparator<CRLInfo>,
Comparable<CRLInfo> {
    private static final Codec<CRLInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)HddsProtos.CRLInfoProto.getDefaultInstance()), proto -> CRLInfo.fromProtobuf(proto, CRLCodec::toIOException), CRLInfo::getProtobuf);
    private final X509CRL x509CRL;
    private final long creationTimestamp;
    private final long crlSequenceID;
    private final Instant revocationTime;

    public static Codec<CRLInfo> getCodec() {
        return CODEC;
    }

    private CRLInfo(X509CRL x509CRL, long creationTimestamp, long crlSequenceID) {
        assert (x509CRL != null && !x509CRL.getRevokedCertificates().isEmpty());
        this.x509CRL = x509CRL;
        this.creationTimestamp = creationTimestamp;
        this.crlSequenceID = crlSequenceID;
        X509CRLEntry entry = x509CRL.getRevokedCertificates().iterator().next();
        this.revocationTime = Instant.ofEpochMilli(entry.getRevocationDate().getTime());
    }

    public static CRLInfo fromProtobuf(HddsProtos.CRLInfoProto info) throws CRLException {
        return CRLInfo.fromProtobuf(info, Function.identity());
    }

    private static <E extends Exception> CRLInfo fromProtobuf(HddsProtos.CRLInfoProto info, Function<CRLException, E> convertor) throws E {
        return new Builder().setX509CRL(CRLCodec.getX509CRL(info.getX509CRL(), convertor)).setCreationTimestamp(info.getCreationTimestamp()).setCrlSequenceID(info.getCrlSequenceID()).build();
    }

    public HddsProtos.CRLInfoProto getProtobuf() throws SCMSecurityException {
        return HddsProtos.CRLInfoProto.newBuilder().setX509CRL(CRLCodec.getPEMEncodedString(this.getX509CRL())).setCreationTimestamp(this.getCreationTimestamp()).setCrlSequenceID(this.getCrlSequenceID()).build();
    }

    public static CRLInfo fromCRLProto3(SCMUpdateServiceProtos.CRLInfoProto info) throws CRLException {
        return new Builder().setX509CRL(CRLCodec.getX509CRL(info.getX509CRL())).setCreationTimestamp(info.getCreationTimestamp()).setCrlSequenceID(info.getCrlSequenceID()).build();
    }

    public SCMUpdateServiceProtos.CRLInfoProto getCRLProto3() throws SCMSecurityException {
        return SCMUpdateServiceProtos.CRLInfoProto.newBuilder().setX509CRL(CRLCodec.getPEMEncodedString(this.getX509CRL())).setCreationTimestamp(this.getCreationTimestamp()).setCrlSequenceID(this.getCrlSequenceID()).build();
    }

    public X509CRL getX509CRL() {
        return this.x509CRL;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public long getCrlSequenceID() {
        return this.crlSequenceID;
    }

    public boolean shouldRevokeNow() {
        return this.revocationTime.isBefore(Instant.now());
    }

    public Instant getRevocationTime() {
        return this.revocationTime;
    }

    @Override
    public int compareTo(@NotNull CRLInfo o) {
        return this.compare(this, o);
    }

    @Override
    public int compare(CRLInfo o1, CRLInfo o2) {
        return Long.compare(o1.getCreationTimestamp(), o2.getCreationTimestamp());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRLInfo that = (CRLInfo)o;
        return this.crlSequenceID == that.crlSequenceID && this.getX509CRL().equals(that.x509CRL) && this.creationTimestamp == that.creationTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.getX509CRL(), this.getCreationTimestamp());
    }

    public String toString() {
        return "CRLInfo{crlSequenceID=" + this.crlSequenceID + ", x509CRL=" + this.x509CRL.toString() + ", creationTimestamp=" + this.creationTimestamp + '}';
    }

    public static class Builder {
        private X509CRL x509CRL;
        private long creationTimestamp;
        private long crlSequenceID;

        public Builder setX509CRL(X509CRL x509CRL) {
            this.x509CRL = x509CRL;
            return this;
        }

        public Builder setCreationTimestamp(long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public Builder setCrlSequenceID(long crlSequenceID) {
            this.crlSequenceID = crlSequenceID;
            return this;
        }

        public CRLInfo build() {
            return new CRLInfo(this.x509CRL, this.creationTimestamp, this.crlSequenceID);
        }
    }
}

