/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.GroupInfo;
import org.apache.ranger.plugin.model.UserInfo;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerUserStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CLOUD_IDENTITY_NAME = "cloud_id";
    private Long userStoreVersion;
    private Date userStoreUpdateTime;
    private Map<String, Map<String, String>> userAttrMapping;
    private Map<String, Map<String, String>> groupAttrMapping;
    private Map<String, Set<String>> userGroupMapping;
    private Map<String, String> userCloudIdMapping;
    private Map<String, String> groupCloudIdMapping;

    public RangerUserStore() {
        this(-1L, null, null, null);
    }

    public RangerUserStore(Long userStoreVersion, Set<UserInfo> users, Set<GroupInfo> groups, Map<String, Set<String>> userGroups) {
        this.setUserStoreVersion(userStoreVersion);
        this.setUserStoreUpdateTime(new Date());
        this.setUserGroupMapping(userGroups);
        this.buildMap(users, groups);
    }

    public Long getUserStoreVersion() {
        return this.userStoreVersion;
    }

    public void setUserStoreVersion(Long userStoreVersion) {
        this.userStoreVersion = userStoreVersion;
    }

    public Date getUserStoreUpdateTime() {
        return this.userStoreUpdateTime;
    }

    public void setUserStoreUpdateTime(Date userStoreUpdateTime) {
        this.userStoreUpdateTime = userStoreUpdateTime;
    }

    public Map<String, Map<String, String>> getUserAttrMapping() {
        return this.userAttrMapping;
    }

    public void setUserAttrMapping(Map<String, Map<String, String>> userAttrMapping) {
        this.userAttrMapping = userAttrMapping;
    }

    public Map<String, Map<String, String>> getGroupAttrMapping() {
        return this.groupAttrMapping;
    }

    public void setGroupAttrMapping(Map<String, Map<String, String>> groupAttrMapping) {
        this.groupAttrMapping = groupAttrMapping;
    }

    public Map<String, Set<String>> getUserGroupMapping() {
        return this.userGroupMapping;
    }

    public void setUserGroupMapping(Map<String, Set<String>> userGroupMapping) {
        this.userGroupMapping = userGroupMapping;
    }

    public Map<String, String> getUserCloudIdMapping() {
        return this.userCloudIdMapping;
    }

    public void setUserCloudIdMapping(Map<String, String> userCloudIdMapping) {
        this.userCloudIdMapping = userCloudIdMapping;
    }

    public Map<String, String> getGroupCloudIdMapping() {
        return this.groupCloudIdMapping;
    }

    public void setGroupCloudIdMapping(Map<String, String> groupCloudIdMapping) {
        this.groupCloudIdMapping = groupCloudIdMapping;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerUserStore={").append("userStoreVersion=").append(this.userStoreVersion).append(", ").append("userStoreUpdateTime=").append(this.userStoreUpdateTime).append(", ");
        sb.append("users={");
        if (MapUtils.isNotEmpty(this.userAttrMapping)) {
            for (String user : this.userAttrMapping.keySet()) {
                sb.append(user);
            }
        }
        sb.append("}, ");
        sb.append("groups={");
        if (MapUtils.isNotEmpty(this.groupAttrMapping)) {
            for (String group : this.groupAttrMapping.keySet()) {
                sb.append(group);
            }
        }
        sb.append("}");
        sb.append("}");
        return sb;
    }

    private void buildMap(Set<UserInfo> users, Set<GroupInfo> groups) {
        String cloudId;
        if (CollectionUtils.isNotEmpty(users)) {
            this.userAttrMapping = new HashMap<String, Map<String, String>>();
            this.userCloudIdMapping = new HashMap<String, String>();
            for (UserInfo user : users) {
                String username = user.getName();
                Map<String, String> userAttrs = user.getOtherAttributes();
                if (!MapUtils.isNotEmpty(userAttrs)) continue;
                this.userAttrMapping.put(username, userAttrs);
                cloudId = userAttrs.get(CLOUD_IDENTITY_NAME);
                if (!StringUtils.isNotEmpty((String)cloudId)) continue;
                this.userCloudIdMapping.put(cloudId, username);
            }
        }
        if (CollectionUtils.isNotEmpty(groups)) {
            this.groupAttrMapping = new HashMap<String, Map<String, String>>();
            this.groupCloudIdMapping = new HashMap<String, String>();
            for (GroupInfo group : groups) {
                String groupname = group.getName();
                Map<String, String> groupAttrs = group.getOtherAttributes();
                if (!MapUtils.isNotEmpty(groupAttrs)) continue;
                this.groupAttrMapping.put(groupname, groupAttrs);
                cloudId = groupAttrs.get(CLOUD_IDENTITY_NAME);
                if (!StringUtils.isNotEmpty((String)cloudId)) continue;
                this.groupCloudIdMapping.put(cloudId, groupname);
            }
        }
    }
}

